/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.APIServer;
import io.fabric8.openshift.api.model.APIServerFluent;
import io.fabric8.openshift.api.model.APIServerFluentImpl;

public class APIServerBuilder
extends APIServerFluentImpl<APIServerBuilder>
implements VisitableBuilder<APIServer, APIServerBuilder> {
    APIServerFluent<?> fluent;
    Boolean validationEnabled;

    public APIServerBuilder() {
        this(true);
    }

    public APIServerBuilder(Boolean validationEnabled) {
        this(new APIServer(), validationEnabled);
    }

    public APIServerBuilder(APIServerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public APIServerBuilder(APIServerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIServer(), validationEnabled);
    }

    public APIServerBuilder(APIServerFluent<?> fluent, APIServer instance) {
        this(fluent, instance, true);
    }

    public APIServerBuilder(APIServerFluent<?> fluent, APIServer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public APIServerBuilder(APIServer instance) {
        this(instance, (Boolean)true);
    }

    public APIServerBuilder(APIServer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public APIServer build() {
        APIServer buildable = new APIServer(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIServerBuilder that = (APIServerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

