/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.TunedProfile;
import io.fabric8.openshift.api.model.tuned.v1.TunedProfileBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TunedProfileFluentImpl;
import io.fabric8.openshift.api.model.tuned.v1.TunedRecommend;
import io.fabric8.openshift.api.model.tuned.v1.TunedRecommendBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TunedRecommendFluentImpl;
import io.fabric8.openshift.api.model.tuned.v1.TunedSpec;
import io.fabric8.openshift.api.model.tuned.v1.TunedSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TunedSpecFluentImpl<A extends TunedSpecFluent<A>>
extends BaseFluent<A>
implements TunedSpecFluent<A> {
    private String managementState;
    private List<TunedProfileBuilder> profile = new ArrayList<TunedProfileBuilder>();
    private List<TunedRecommendBuilder> recommend = new ArrayList<TunedRecommendBuilder>();

    public TunedSpecFluentImpl() {
    }

    public TunedSpecFluentImpl(TunedSpec instance) {
        this.withManagementState(instance.getManagementState());
        this.withProfile(instance.getProfile());
        this.withRecommend(instance.getRecommend());
    }

    @Override
    public String getManagementState() {
        return this.managementState;
    }

    @Override
    public A withManagementState(String managementState) {
        this.managementState = managementState;
        return (A)this;
    }

    @Override
    public Boolean hasManagementState() {
        return this.managementState != null;
    }

    @Override
    @Deprecated
    public A withNewManagementState(String arg0) {
        return this.withManagementState(new String(arg0));
    }

    @Override
    public A addToProfile(int index, TunedProfile item) {
        if (this.profile == null) {
            this.profile = new ArrayList<TunedProfileBuilder>();
        }
        TunedProfileBuilder builder = new TunedProfileBuilder(item);
        this._visitables.get((Object)"profile").add(index >= 0 ? index : this._visitables.get((Object)"profile").size(), builder);
        this.profile.add(index >= 0 ? index : this.profile.size(), builder);
        return (A)this;
    }

    @Override
    public A setToProfile(int index, TunedProfile item) {
        if (this.profile == null) {
            this.profile = new ArrayList<TunedProfileBuilder>();
        }
        TunedProfileBuilder builder = new TunedProfileBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"profile").size()) {
            this._visitables.get((Object)"profile").add(builder);
        } else {
            this._visitables.get((Object)"profile").set(index, builder);
        }
        if (index < 0 || index >= this.profile.size()) {
            this.profile.add(builder);
        } else {
            this.profile.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToProfile(TunedProfile ... items) {
        if (this.profile == null) {
            this.profile = new ArrayList<TunedProfileBuilder>();
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get((Object)"profile").add(builder);
            this.profile.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToProfile(Collection<TunedProfile> items) {
        if (this.profile == null) {
            this.profile = new ArrayList<TunedProfileBuilder>();
        }
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get((Object)"profile").add(builder);
            this.profile.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromProfile(TunedProfile ... items) {
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get((Object)"profile").remove(builder);
            if (this.profile == null) continue;
            this.profile.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromProfile(Collection<TunedProfile> items) {
        for (TunedProfile item : items) {
            TunedProfileBuilder builder = new TunedProfileBuilder(item);
            this._visitables.get((Object)"profile").remove(builder);
            if (this.profile == null) continue;
            this.profile.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromProfile(Predicate<TunedProfileBuilder> predicate) {
        if (this.profile == null) {
            return (A)this;
        }
        Iterator<TunedProfileBuilder> each = this.profile.iterator();
        List visitables = this._visitables.get((Object)"profile");
        while (each.hasNext()) {
            TunedProfileBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TunedProfile> getProfile() {
        return TunedSpecFluentImpl.build(this.profile);
    }

    @Override
    public List<TunedProfile> buildProfile() {
        return TunedSpecFluentImpl.build(this.profile);
    }

    @Override
    public TunedProfile buildProfile(int index) {
        return this.profile.get(index).build();
    }

    @Override
    public TunedProfile buildFirstProfile() {
        return this.profile.get(0).build();
    }

    @Override
    public TunedProfile buildLastProfile() {
        return this.profile.get(this.profile.size() - 1).build();
    }

    @Override
    public TunedProfile buildMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        for (TunedProfileBuilder item : this.profile) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        for (TunedProfileBuilder item : this.profile) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withProfile(List<TunedProfile> profile) {
        if (this.profile != null) {
            this._visitables.get((Object)"profile").removeAll(this.profile);
        }
        if (profile != null) {
            this.profile = new ArrayList<TunedProfileBuilder>();
            for (TunedProfile item : profile) {
                this.addToProfile(item);
            }
        } else {
            this.profile = null;
        }
        return (A)this;
    }

    @Override
    public A withProfile(TunedProfile ... profile) {
        if (this.profile != null) {
            this.profile.clear();
        }
        if (profile != null) {
            for (TunedProfile item : profile) {
                this.addToProfile(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null && !this.profile.isEmpty();
    }

    @Override
    public A addNewProfile(String data, String name) {
        return this.addToProfile(new TunedProfile(data, name));
    }

    @Override
    public TunedSpecFluent.ProfileNested<A> addNewProfile() {
        return new ProfileNestedImpl();
    }

    @Override
    public TunedSpecFluent.ProfileNested<A> addNewProfileLike(TunedProfile item) {
        return new ProfileNestedImpl(-1, item);
    }

    @Override
    public TunedSpecFluent.ProfileNested<A> setNewProfileLike(int index, TunedProfile item) {
        return new ProfileNestedImpl(index, item);
    }

    @Override
    public TunedSpecFluent.ProfileNested<A> editProfile(int index) {
        if (this.profile.size() <= index) {
            throw new RuntimeException("Can't edit profile. Index exceeds size.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    @Override
    public TunedSpecFluent.ProfileNested<A> editFirstProfile() {
        if (this.profile.size() == 0) {
            throw new RuntimeException("Can't edit first profile. The list is empty.");
        }
        return this.setNewProfileLike(0, this.buildProfile(0));
    }

    @Override
    public TunedSpecFluent.ProfileNested<A> editLastProfile() {
        int index = this.profile.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last profile. The list is empty.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    @Override
    public TunedSpecFluent.ProfileNested<A> editMatchingProfile(Predicate<TunedProfileBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.profile.size(); ++i) {
            if (!predicate.test(this.profile.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching profile. No match found.");
        }
        return this.setNewProfileLike(index, this.buildProfile(index));
    }

    @Override
    public A addToRecommend(int index, TunedRecommend item) {
        if (this.recommend == null) {
            this.recommend = new ArrayList<TunedRecommendBuilder>();
        }
        TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
        this._visitables.get((Object)"recommend").add(index >= 0 ? index : this._visitables.get((Object)"recommend").size(), builder);
        this.recommend.add(index >= 0 ? index : this.recommend.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRecommend(int index, TunedRecommend item) {
        if (this.recommend == null) {
            this.recommend = new ArrayList<TunedRecommendBuilder>();
        }
        TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"recommend").size()) {
            this._visitables.get((Object)"recommend").add(builder);
        } else {
            this._visitables.get((Object)"recommend").set(index, builder);
        }
        if (index < 0 || index >= this.recommend.size()) {
            this.recommend.add(builder);
        } else {
            this.recommend.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRecommend(TunedRecommend ... items) {
        if (this.recommend == null) {
            this.recommend = new ArrayList<TunedRecommendBuilder>();
        }
        for (TunedRecommend item : items) {
            TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
            this._visitables.get((Object)"recommend").add(builder);
            this.recommend.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRecommend(Collection<TunedRecommend> items) {
        if (this.recommend == null) {
            this.recommend = new ArrayList<TunedRecommendBuilder>();
        }
        for (TunedRecommend item : items) {
            TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
            this._visitables.get((Object)"recommend").add(builder);
            this.recommend.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRecommend(TunedRecommend ... items) {
        for (TunedRecommend item : items) {
            TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
            this._visitables.get((Object)"recommend").remove(builder);
            if (this.recommend == null) continue;
            this.recommend.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRecommend(Collection<TunedRecommend> items) {
        for (TunedRecommend item : items) {
            TunedRecommendBuilder builder = new TunedRecommendBuilder(item);
            this._visitables.get((Object)"recommend").remove(builder);
            if (this.recommend == null) continue;
            this.recommend.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRecommend(Predicate<TunedRecommendBuilder> predicate) {
        if (this.recommend == null) {
            return (A)this;
        }
        Iterator<TunedRecommendBuilder> each = this.recommend.iterator();
        List visitables = this._visitables.get((Object)"recommend");
        while (each.hasNext()) {
            TunedRecommendBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TunedRecommend> getRecommend() {
        return TunedSpecFluentImpl.build(this.recommend);
    }

    @Override
    public List<TunedRecommend> buildRecommend() {
        return TunedSpecFluentImpl.build(this.recommend);
    }

    @Override
    public TunedRecommend buildRecommend(int index) {
        return this.recommend.get(index).build();
    }

    @Override
    public TunedRecommend buildFirstRecommend() {
        return this.recommend.get(0).build();
    }

    @Override
    public TunedRecommend buildLastRecommend() {
        return this.recommend.get(this.recommend.size() - 1).build();
    }

    @Override
    public TunedRecommend buildMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
        for (TunedRecommendBuilder item : this.recommend) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
        for (TunedRecommendBuilder item : this.recommend) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRecommend(List<TunedRecommend> recommend) {
        if (this.recommend != null) {
            this._visitables.get((Object)"recommend").removeAll(this.recommend);
        }
        if (recommend != null) {
            this.recommend = new ArrayList<TunedRecommendBuilder>();
            for (TunedRecommend item : recommend) {
                this.addToRecommend(item);
            }
        } else {
            this.recommend = null;
        }
        return (A)this;
    }

    @Override
    public A withRecommend(TunedRecommend ... recommend) {
        if (this.recommend != null) {
            this.recommend.clear();
        }
        if (recommend != null) {
            for (TunedRecommend item : recommend) {
                this.addToRecommend(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRecommend() {
        return this.recommend != null && !this.recommend.isEmpty();
    }

    @Override
    public TunedSpecFluent.RecommendNested<A> addNewRecommend() {
        return new RecommendNestedImpl();
    }

    @Override
    public TunedSpecFluent.RecommendNested<A> addNewRecommendLike(TunedRecommend item) {
        return new RecommendNestedImpl(-1, item);
    }

    @Override
    public TunedSpecFluent.RecommendNested<A> setNewRecommendLike(int index, TunedRecommend item) {
        return new RecommendNestedImpl(index, item);
    }

    @Override
    public TunedSpecFluent.RecommendNested<A> editRecommend(int index) {
        if (this.recommend.size() <= index) {
            throw new RuntimeException("Can't edit recommend. Index exceeds size.");
        }
        return this.setNewRecommendLike(index, this.buildRecommend(index));
    }

    @Override
    public TunedSpecFluent.RecommendNested<A> editFirstRecommend() {
        if (this.recommend.size() == 0) {
            throw new RuntimeException("Can't edit first recommend. The list is empty.");
        }
        return this.setNewRecommendLike(0, this.buildRecommend(0));
    }

    @Override
    public TunedSpecFluent.RecommendNested<A> editLastRecommend() {
        int index = this.recommend.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last recommend. The list is empty.");
        }
        return this.setNewRecommendLike(index, this.buildRecommend(index));
    }

    @Override
    public TunedSpecFluent.RecommendNested<A> editMatchingRecommend(Predicate<TunedRecommendBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.recommend.size(); ++i) {
            if (!predicate.test(this.recommend.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching recommend. No match found.");
        }
        return this.setNewRecommendLike(index, this.buildRecommend(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TunedSpecFluentImpl that = (TunedSpecFluentImpl)o;
        if (this.managementState != null ? !this.managementState.equals(that.managementState) : that.managementState != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        return !(this.recommend != null ? !this.recommend.equals(that.recommend) : that.recommend != null);
    }

    public int hashCode() {
        return Objects.hash(this.managementState, this.profile, this.recommend, super.hashCode());
    }

    public class RecommendNestedImpl<N>
    extends TunedRecommendFluentImpl<TunedSpecFluent.RecommendNested<N>>
    implements TunedSpecFluent.RecommendNested<N>,
    Nested<N> {
        private final TunedRecommendBuilder builder;
        private final int index;

        RecommendNestedImpl(int index, TunedRecommend item) {
            this.index = index;
            this.builder = new TunedRecommendBuilder(this, item);
        }

        RecommendNestedImpl() {
            this.index = -1;
            this.builder = new TunedRecommendBuilder(this);
        }

        @Override
        public N and() {
            return (N)TunedSpecFluentImpl.this.setToRecommend(this.index, this.builder.build());
        }

        @Override
        public N endRecommend() {
            return this.and();
        }
    }

    public class ProfileNestedImpl<N>
    extends TunedProfileFluentImpl<TunedSpecFluent.ProfileNested<N>>
    implements TunedSpecFluent.ProfileNested<N>,
    Nested<N> {
        private final TunedProfileBuilder builder;
        private final int index;

        ProfileNestedImpl(int index, TunedProfile item) {
            this.index = index;
            this.builder = new TunedProfileBuilder(this, item);
        }

        ProfileNestedImpl() {
            this.index = -1;
            this.builder = new TunedProfileBuilder(this);
        }

        @Override
        public N and() {
            return (N)TunedSpecFluentImpl.this.setToProfile(this.index, this.builder.build());
        }

        @Override
        public N endProfile() {
            return this.and();
        }
    }
}

