package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageVersionMigrationListBuilder extends StorageVersionMigrationListFluentImpl<StorageVersionMigrationListBuilder> implements VisitableBuilder<StorageVersionMigrationList,StorageVersionMigrationListBuilder>{
  public StorageVersionMigrationListBuilder() {
    this(false);
  }
  public StorageVersionMigrationListBuilder(Boolean validationEnabled) {
    this(new StorageVersionMigrationList(), validationEnabled);
  }
  public StorageVersionMigrationListBuilder(StorageVersionMigrationListFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageVersionMigrationListBuilder(StorageVersionMigrationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageVersionMigrationList(), validationEnabled);
  }
  public StorageVersionMigrationListBuilder(StorageVersionMigrationListFluent<?> fluent,StorageVersionMigrationList instance) {
    this(fluent, instance, false);
  }
  public StorageVersionMigrationListBuilder(StorageVersionMigrationListFluent<?> fluent,StorageVersionMigrationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StorageVersionMigrationListBuilder(StorageVersionMigrationList instance) {
    this(instance,false);
  }
  public StorageVersionMigrationListBuilder(StorageVersionMigrationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StorageVersionMigrationListFluent<?> fluent;
  Boolean validationEnabled;
  public StorageVersionMigrationList build() {
    StorageVersionMigrationList buildable = new StorageVersionMigrationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}