package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageStateSpecBuilder extends StorageStateSpecFluentImpl<StorageStateSpecBuilder> implements VisitableBuilder<StorageStateSpec,StorageStateSpecBuilder>{
  public StorageStateSpecBuilder() {
    this(false);
  }
  public StorageStateSpecBuilder(Boolean validationEnabled) {
    this(new StorageStateSpec(), validationEnabled);
  }
  public StorageStateSpecBuilder(StorageStateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageStateSpecBuilder(StorageStateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageStateSpec(), validationEnabled);
  }
  public StorageStateSpecBuilder(StorageStateSpecFluent<?> fluent,StorageStateSpec instance) {
    this(fluent, instance, false);
  }
  public StorageStateSpecBuilder(StorageStateSpecFluent<?> fluent,StorageStateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withResource(instance.getResource()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StorageStateSpecBuilder(StorageStateSpec instance) {
    this(instance,false);
  }
  public StorageStateSpecBuilder(StorageStateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withResource(instance.getResource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StorageStateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StorageStateSpec build() {
    StorageStateSpec buildable = new StorageStateSpec(fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}