package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageStateBuilder extends StorageStateFluentImpl<StorageStateBuilder> implements VisitableBuilder<StorageState,StorageStateBuilder>{
  public StorageStateBuilder() {
    this(false);
  }
  public StorageStateBuilder(Boolean validationEnabled) {
    this(new StorageState(), validationEnabled);
  }
  public StorageStateBuilder(StorageStateFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageStateBuilder(StorageStateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageState(), validationEnabled);
  }
  public StorageStateBuilder(StorageStateFluent<?> fluent,StorageState instance) {
    this(fluent, instance, false);
  }
  public StorageStateBuilder(StorageStateFluent<?> fluent,StorageState instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StorageStateBuilder(StorageState instance) {
    this(instance,false);
  }
  public StorageStateBuilder(StorageState instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StorageStateFluent<?> fluent;
  Boolean validationEnabled;
  public StorageState build() {
    StorageState buildable = new StorageState(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}