package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SubscriptionBuilder extends SubscriptionFluent<SubscriptionBuilder> implements VisitableBuilder<Subscription,SubscriptionBuilder>{
  public SubscriptionBuilder() {
    this(new Subscription());
  }
  
  public SubscriptionBuilder(SubscriptionFluent<?> fluent) {
    this(fluent, new Subscription());
  }
  
  public SubscriptionBuilder(SubscriptionFluent<?> fluent,Subscription instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SubscriptionBuilder(Subscription instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SubscriptionFluent<?> fluent;
  
  public Subscription build() {
    Subscription buildable = new Subscription(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}