package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StepResourceBuilder extends StepResourceFluent<StepResourceBuilder> implements VisitableBuilder<StepResource,StepResourceBuilder>{
  public StepResourceBuilder() {
    this(new StepResource());
  }
  
  public StepResourceBuilder(StepResourceFluent<?> fluent) {
    this(fluent, new StepResource());
  }
  
  public StepResourceBuilder(StepResourceFluent<?> fluent,StepResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StepResourceBuilder(StepResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StepResourceFluent<?> fluent;
  
  public StepResource build() {
    StepResource buildable = new StepResource(fluent.getGroup(),fluent.getKind(),fluent.getManifest(),fluent.getName(),fluent.getSourceName(),fluent.getSourceNamespace(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}