package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomResourceDefinitionsFluent<A extends CustomResourceDefinitionsFluent<A>> extends BaseFluent<A>{
  public CustomResourceDefinitionsFluent() {
  }
  
  public CustomResourceDefinitionsFluent(CustomResourceDefinitions instance) {
    this.copyInstance(instance);
  }
  private ArrayList<CRDDescriptionBuilder> owned = new ArrayList<CRDDescriptionBuilder>();
  private ArrayList<CRDDescriptionBuilder> required = new ArrayList<CRDDescriptionBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomResourceDefinitions instance) {
    instance = (instance != null ? instance : new CustomResourceDefinitions());
    if (instance != null) {
          this.withOwned(instance.getOwned());
          this.withRequired(instance.getRequired());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToOwned(int index,CRDDescription item) {
    if (this.owned == null) {this.owned = new ArrayList<CRDDescriptionBuilder>();}
    CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
    if (index < 0 || index >= owned.size()) {
        _visitables.get("owned").add(builder);
        owned.add(builder);
    } else {
        _visitables.get("owned").add(builder);
        owned.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToOwned(int index,CRDDescription item) {
    if (this.owned == null) {this.owned = new ArrayList<CRDDescriptionBuilder>();}
    CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
    if (index < 0 || index >= owned.size()) {
        _visitables.get("owned").add(builder);
        owned.add(builder);
    } else {
        _visitables.get("owned").add(builder);
        owned.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToOwned(io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescription... items) {
    if (this.owned == null) {this.owned = new ArrayList<CRDDescriptionBuilder>();}
    for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").add(builder);this.owned.add(builder);} return (A)this;
  }
  
  public A addAllToOwned(Collection<CRDDescription> items) {
    if (this.owned == null) {this.owned = new ArrayList<CRDDescriptionBuilder>();}
    for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").add(builder);this.owned.add(builder);} return (A)this;
  }
  
  public A removeFromOwned(io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescription... items) {
    if (this.owned == null) return (A)this;
    for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").remove(builder); this.owned.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOwned(Collection<CRDDescription> items) {
    if (this.owned == null) return (A)this;
    for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("owned").remove(builder); this.owned.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOwned(Predicate<CRDDescriptionBuilder> predicate) {
    if (owned == null) return (A) this;
    final Iterator<CRDDescriptionBuilder> each = owned.iterator();
    final List visitables = _visitables.get("owned");
    while (each.hasNext()) {
      CRDDescriptionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CRDDescription> buildOwned() {
    return this.owned != null ? build(owned) : null;
  }
  
  public CRDDescription buildOwned(int index) {
    return this.owned.get(index).build();
  }
  
  public CRDDescription buildFirstOwned() {
    return this.owned.get(0).build();
  }
  
  public CRDDescription buildLastOwned() {
    return this.owned.get(owned.size() - 1).build();
  }
  
  public CRDDescription buildMatchingOwned(Predicate<CRDDescriptionBuilder> predicate) {
      for (CRDDescriptionBuilder item : owned) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOwned(Predicate<CRDDescriptionBuilder> predicate) {
      for (CRDDescriptionBuilder item : owned) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOwned(List<CRDDescription> owned) {
    if (this.owned != null) {
      this._visitables.get("owned").clear();
    }
    if (owned != null) {
        this.owned = new ArrayList();
        for (CRDDescription item : owned) {
          this.addToOwned(item);
        }
    } else {
      this.owned = null;
    }
    return (A) this;
  }
  
  public A withOwned(io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescription... owned) {
    if (this.owned != null) {
        this.owned.clear();
        _visitables.remove("owned");
    }
    if (owned != null) {
      for (CRDDescription item : owned) {
        this.addToOwned(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasOwned() {
    return this.owned != null && !this.owned.isEmpty();
  }
  
  public OwnedNested<A> addNewOwned() {
    return new OwnedNested(-1, null);
  }
  
  public OwnedNested<A> addNewOwnedLike(CRDDescription item) {
    return new OwnedNested(-1, item);
  }
  
  public OwnedNested<A> setNewOwnedLike(int index,CRDDescription item) {
    return new OwnedNested(index, item);
  }
  
  public OwnedNested<A> editOwned(int index) {
    if (owned.size() <= index) throw new RuntimeException("Can't edit owned. Index exceeds size.");
    return setNewOwnedLike(index, buildOwned(index));
  }
  
  public OwnedNested<A> editFirstOwned() {
    if (owned.size() == 0) throw new RuntimeException("Can't edit first owned. The list is empty.");
    return setNewOwnedLike(0, buildOwned(0));
  }
  
  public OwnedNested<A> editLastOwned() {
    int index = owned.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last owned. The list is empty.");
    return setNewOwnedLike(index, buildOwned(index));
  }
  
  public OwnedNested<A> editMatchingOwned(Predicate<CRDDescriptionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<owned.size();i++) { 
    if (predicate.test(owned.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching owned. No match found.");
    return setNewOwnedLike(index, buildOwned(index));
  }
  
  public A addToRequired(int index,CRDDescription item) {
    if (this.required == null) {this.required = new ArrayList<CRDDescriptionBuilder>();}
    CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
    if (index < 0 || index >= required.size()) {
        _visitables.get("required").add(builder);
        required.add(builder);
    } else {
        _visitables.get("required").add(builder);
        required.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRequired(int index,CRDDescription item) {
    if (this.required == null) {this.required = new ArrayList<CRDDescriptionBuilder>();}
    CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);
    if (index < 0 || index >= required.size()) {
        _visitables.get("required").add(builder);
        required.add(builder);
    } else {
        _visitables.get("required").add(builder);
        required.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRequired(io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescription... items) {
    if (this.required == null) {this.required = new ArrayList<CRDDescriptionBuilder>();}
    for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").add(builder);this.required.add(builder);} return (A)this;
  }
  
  public A addAllToRequired(Collection<CRDDescription> items) {
    if (this.required == null) {this.required = new ArrayList<CRDDescriptionBuilder>();}
    for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").add(builder);this.required.add(builder);} return (A)this;
  }
  
  public A removeFromRequired(io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescription... items) {
    if (this.required == null) return (A)this;
    for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").remove(builder); this.required.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRequired(Collection<CRDDescription> items) {
    if (this.required == null) return (A)this;
    for (CRDDescription item : items) {CRDDescriptionBuilder builder = new CRDDescriptionBuilder(item);_visitables.get("required").remove(builder); this.required.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRequired(Predicate<CRDDescriptionBuilder> predicate) {
    if (required == null) return (A) this;
    final Iterator<CRDDescriptionBuilder> each = required.iterator();
    final List visitables = _visitables.get("required");
    while (each.hasNext()) {
      CRDDescriptionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CRDDescription> buildRequired() {
    return this.required != null ? build(required) : null;
  }
  
  public CRDDescription buildRequired(int index) {
    return this.required.get(index).build();
  }
  
  public CRDDescription buildFirstRequired() {
    return this.required.get(0).build();
  }
  
  public CRDDescription buildLastRequired() {
    return this.required.get(required.size() - 1).build();
  }
  
  public CRDDescription buildMatchingRequired(Predicate<CRDDescriptionBuilder> predicate) {
      for (CRDDescriptionBuilder item : required) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRequired(Predicate<CRDDescriptionBuilder> predicate) {
      for (CRDDescriptionBuilder item : required) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRequired(List<CRDDescription> required) {
    if (this.required != null) {
      this._visitables.get("required").clear();
    }
    if (required != null) {
        this.required = new ArrayList();
        for (CRDDescription item : required) {
          this.addToRequired(item);
        }
    } else {
      this.required = null;
    }
    return (A) this;
  }
  
  public A withRequired(io.fabric8.openshift.api.model.operatorhub.v1alpha1.CRDDescription... required) {
    if (this.required != null) {
        this.required.clear();
        _visitables.remove("required");
    }
    if (required != null) {
      for (CRDDescription item : required) {
        this.addToRequired(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRequired() {
    return this.required != null && !this.required.isEmpty();
  }
  
  public RequiredNested<A> addNewRequired() {
    return new RequiredNested(-1, null);
  }
  
  public RequiredNested<A> addNewRequiredLike(CRDDescription item) {
    return new RequiredNested(-1, item);
  }
  
  public RequiredNested<A> setNewRequiredLike(int index,CRDDescription item) {
    return new RequiredNested(index, item);
  }
  
  public RequiredNested<A> editRequired(int index) {
    if (required.size() <= index) throw new RuntimeException("Can't edit required. Index exceeds size.");
    return setNewRequiredLike(index, buildRequired(index));
  }
  
  public RequiredNested<A> editFirstRequired() {
    if (required.size() == 0) throw new RuntimeException("Can't edit first required. The list is empty.");
    return setNewRequiredLike(0, buildRequired(0));
  }
  
  public RequiredNested<A> editLastRequired() {
    int index = required.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last required. The list is empty.");
    return setNewRequiredLike(index, buildRequired(index));
  }
  
  public RequiredNested<A> editMatchingRequired(Predicate<CRDDescriptionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<required.size();i++) { 
    if (predicate.test(required.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching required. No match found.");
    return setNewRequiredLike(index, buildRequired(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomResourceDefinitionsFluent that = (CustomResourceDefinitionsFluent) o;
    if (!java.util.Objects.equals(owned, that.owned)) return false;
    if (!java.util.Objects.equals(required, that.required)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(owned,  required,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (owned != null && !owned.isEmpty()) { sb.append("owned:"); sb.append(owned + ","); }
    if (required != null && !required.isEmpty()) { sb.append("required:"); sb.append(required + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OwnedNested<N> extends CRDDescriptionFluent<OwnedNested<N>> implements Nested<N>{
    OwnedNested(int index,CRDDescription item) {
      this.index = index;
      this.builder = new CRDDescriptionBuilder(this, item);
    }
    CRDDescriptionBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomResourceDefinitionsFluent.this.setToOwned(index,builder.build());
    }
    
    public N endOwned() {
      return and();
    }
    
  
  }
  public class RequiredNested<N> extends CRDDescriptionFluent<RequiredNested<N>> implements Nested<N>{
    RequiredNested(int index,CRDDescription item) {
      this.index = index;
      this.builder = new CRDDescriptionBuilder(this, item);
    }
    CRDDescriptionBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomResourceDefinitionsFluent.this.setToRequired(index,builder.build());
    }
    
    public N endRequired() {
      return and();
    }
    
  
  }

}