package io.fabric8.openshift.api.model.operatorhub.packages.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ChannelEntryFluent<A extends ChannelEntryFluent<A>> extends BaseFluent<A>{
  public ChannelEntryFluent() {
  }
  
  public ChannelEntryFluent(ChannelEntry instance) {
    this.copyInstance(instance);
  }
  private DeprecationBuilder deprecation;
  private String name;
  private String version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ChannelEntry instance) {
    instance = (instance != null ? instance : new ChannelEntry());
    if (instance != null) {
          this.withDeprecation(instance.getDeprecation());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Deprecation buildDeprecation() {
    return this.deprecation != null ? this.deprecation.build() : null;
  }
  
  public A withDeprecation(Deprecation deprecation) {
    this._visitables.remove("deprecation");
    if (deprecation != null) {
        this.deprecation = new DeprecationBuilder(deprecation);
        this._visitables.get("deprecation").add(this.deprecation);
    } else {
        this.deprecation = null;
        this._visitables.get("deprecation").remove(this.deprecation);
    }
    return (A) this;
  }
  
  public boolean hasDeprecation() {
    return this.deprecation != null;
  }
  
  public A withNewDeprecation(String message) {
    return (A)withDeprecation(new Deprecation(message));
  }
  
  public DeprecationNested<A> withNewDeprecation() {
    return new DeprecationNested(null);
  }
  
  public DeprecationNested<A> withNewDeprecationLike(Deprecation item) {
    return new DeprecationNested(item);
  }
  
  public DeprecationNested<A> editDeprecation() {
    return withNewDeprecationLike(java.util.Optional.ofNullable(buildDeprecation()).orElse(null));
  }
  
  public DeprecationNested<A> editOrNewDeprecation() {
    return withNewDeprecationLike(java.util.Optional.ofNullable(buildDeprecation()).orElse(new DeprecationBuilder().build()));
  }
  
  public DeprecationNested<A> editOrNewDeprecationLike(Deprecation item) {
    return withNewDeprecationLike(java.util.Optional.ofNullable(buildDeprecation()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ChannelEntryFluent that = (ChannelEntryFluent) o;
    if (!java.util.Objects.equals(deprecation, that.deprecation)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(deprecation,  name,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (deprecation != null) { sb.append("deprecation:"); sb.append(deprecation + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DeprecationNested<N> extends DeprecationFluent<DeprecationNested<N>> implements Nested<N>{
    DeprecationNested(Deprecation item) {
      this.builder = new DeprecationBuilder(this, item);
    }
    DeprecationBuilder builder;
    
    public N and() {
      return (N) ChannelEntryFluent.this.withDeprecation(builder.build());
    }
    
    public N endDeprecation() {
      return and();
    }
    
  
  }

}