package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OperatorGroupSpecFluent<A extends OperatorGroupSpecFluent<A>> extends BaseFluent<A>{
  public OperatorGroupSpecFluent() {
  }
  
  public OperatorGroupSpecFluent(OperatorGroupSpec instance) {
    this.copyInstance(instance);
  }
  private LabelSelectorBuilder selector;
  private String serviceAccountName;
  private Boolean staticProvidedAPIs;
  private List<String> targetNamespaces = new ArrayList<String>();
  private String upgradeStrategy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OperatorGroupSpec instance) {
    instance = (instance != null ? instance : new OperatorGroupSpec());
    if (instance != null) {
          this.withSelector(instance.getSelector());
          this.withServiceAccountName(instance.getServiceAccountName());
          this.withStaticProvidedAPIs(instance.getStaticProvidedAPIs());
          this.withTargetNamespaces(instance.getTargetNamespaces());
          this.withUpgradeStrategy(instance.getUpgradeStrategy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName = serviceAccountName;
    return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public Boolean getStaticProvidedAPIs() {
    return this.staticProvidedAPIs;
  }
  
  public A withStaticProvidedAPIs(Boolean staticProvidedAPIs) {
    this.staticProvidedAPIs = staticProvidedAPIs;
    return (A) this;
  }
  
  public boolean hasStaticProvidedAPIs() {
    return this.staticProvidedAPIs != null;
  }
  
  public A addToTargetNamespaces(int index,String item) {
    if (this.targetNamespaces == null) {this.targetNamespaces = new ArrayList<String>();}
    this.targetNamespaces.add(index, item);
    return (A)this;
  }
  
  public A setToTargetNamespaces(int index,String item) {
    if (this.targetNamespaces == null) {this.targetNamespaces = new ArrayList<String>();}
    this.targetNamespaces.set(index, item); return (A)this;
  }
  
  public A addToTargetNamespaces(java.lang.String... items) {
    if (this.targetNamespaces == null) {this.targetNamespaces = new ArrayList<String>();}
    for (String item : items) {this.targetNamespaces.add(item);} return (A)this;
  }
  
  public A addAllToTargetNamespaces(Collection<String> items) {
    if (this.targetNamespaces == null) {this.targetNamespaces = new ArrayList<String>();}
    for (String item : items) {this.targetNamespaces.add(item);} return (A)this;
  }
  
  public A removeFromTargetNamespaces(java.lang.String... items) {
    if (this.targetNamespaces == null) return (A)this;
    for (String item : items) { this.targetNamespaces.remove(item);} return (A)this;
  }
  
  public A removeAllFromTargetNamespaces(Collection<String> items) {
    if (this.targetNamespaces == null) return (A)this;
    for (String item : items) { this.targetNamespaces.remove(item);} return (A)this;
  }
  
  public List<String> getTargetNamespaces() {
    return this.targetNamespaces;
  }
  
  public String getTargetNamespace(int index) {
    return this.targetNamespaces.get(index);
  }
  
  public String getFirstTargetNamespace() {
    return this.targetNamespaces.get(0);
  }
  
  public String getLastTargetNamespace() {
    return this.targetNamespaces.get(targetNamespaces.size() - 1);
  }
  
  public String getMatchingTargetNamespace(Predicate<String> predicate) {
      for (String item : targetNamespaces) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingTargetNamespace(Predicate<String> predicate) {
      for (String item : targetNamespaces) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTargetNamespaces(List<String> targetNamespaces) {
    if (targetNamespaces != null) {
        this.targetNamespaces = new ArrayList();
        for (String item : targetNamespaces) {
          this.addToTargetNamespaces(item);
        }
    } else {
      this.targetNamespaces = null;
    }
    return (A) this;
  }
  
  public A withTargetNamespaces(java.lang.String... targetNamespaces) {
    if (this.targetNamespaces != null) {
        this.targetNamespaces.clear();
        _visitables.remove("targetNamespaces");
    }
    if (targetNamespaces != null) {
      for (String item : targetNamespaces) {
        this.addToTargetNamespaces(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTargetNamespaces() {
    return this.targetNamespaces != null && !this.targetNamespaces.isEmpty();
  }
  
  public String getUpgradeStrategy() {
    return this.upgradeStrategy;
  }
  
  public A withUpgradeStrategy(String upgradeStrategy) {
    this.upgradeStrategy = upgradeStrategy;
    return (A) this;
  }
  
  public boolean hasUpgradeStrategy() {
    return this.upgradeStrategy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OperatorGroupSpecFluent that = (OperatorGroupSpecFluent) o;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
    if (!java.util.Objects.equals(staticProvidedAPIs, that.staticProvidedAPIs)) return false;
    if (!java.util.Objects.equals(targetNamespaces, that.targetNamespaces)) return false;
    if (!java.util.Objects.equals(upgradeStrategy, that.upgradeStrategy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(selector,  serviceAccountName,  staticProvidedAPIs,  targetNamespaces,  upgradeStrategy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (staticProvidedAPIs != null) { sb.append("staticProvidedAPIs:"); sb.append(staticProvidedAPIs + ","); }
    if (targetNamespaces != null && !targetNamespaces.isEmpty()) { sb.append("targetNamespaces:"); sb.append(targetNamespaces + ","); }
    if (upgradeStrategy != null) { sb.append("upgradeStrategy:"); sb.append(upgradeStrategy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withStaticProvidedAPIs() {
    return withStaticProvidedAPIs(true);
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) OperatorGroupSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}