package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PackageChannelBuilder extends PackageChannelFluent<PackageChannelBuilder> implements VisitableBuilder<PackageChannel,PackageChannelBuilder>{
  public PackageChannelBuilder() {
    this(new PackageChannel());
  }
  
  public PackageChannelBuilder(PackageChannelFluent<?> fluent) {
    this(fluent, new PackageChannel());
  }
  
  public PackageChannelBuilder(PackageChannelFluent<?> fluent,PackageChannel instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PackageChannelBuilder(PackageChannel instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PackageChannelFluent<?> fluent;
  
  public PackageChannel build() {
    PackageChannel buildable = new PackageChannel(fluent.getCurrentCSV(),fluent.buildCurrentCSVDesc(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}