package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InstallPlanReferenceBuilder extends InstallPlanReferenceFluentImpl<InstallPlanReferenceBuilder> implements VisitableBuilder<InstallPlanReference,InstallPlanReferenceBuilder>{
  public InstallPlanReferenceBuilder() {
    this(false);
  }
  public InstallPlanReferenceBuilder(Boolean validationEnabled) {
    this(new InstallPlanReference(), validationEnabled);
  }
  public InstallPlanReferenceBuilder(InstallPlanReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public InstallPlanReferenceBuilder(InstallPlanReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InstallPlanReference(), validationEnabled);
  }
  public InstallPlanReferenceBuilder(InstallPlanReferenceFluent<?> fluent,InstallPlanReference instance) {
    this(fluent, instance, false);
  }
  public InstallPlanReferenceBuilder(InstallPlanReferenceFluent<?> fluent,InstallPlanReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withUuid(instance.getUuid()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InstallPlanReferenceBuilder(InstallPlanReference instance) {
    this(instance,false);
  }
  public InstallPlanReferenceBuilder(InstallPlanReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withUuid(instance.getUuid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  InstallPlanReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public InstallPlanReference build() {
    InstallPlanReference buildable = new InstallPlanReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getUuid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}