package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorConditionBuilder extends OperatorConditionFluentImpl<OperatorConditionBuilder> implements VisitableBuilder<OperatorCondition,OperatorConditionBuilder>{
  public OperatorConditionBuilder() {
    this(false);
  }
  public OperatorConditionBuilder(Boolean validationEnabled) {
    this(new OperatorCondition(), validationEnabled);
  }
  public OperatorConditionBuilder(OperatorConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorCondition(), validationEnabled);
  }
  public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,OperatorCondition instance) {
    this(fluent, instance, false);
  }
  public OperatorConditionBuilder(OperatorConditionFluent<?> fluent,OperatorCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorConditionBuilder(OperatorCondition instance) {
    this(instance,false);
  }
  public OperatorConditionBuilder(OperatorCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperatorConditionFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorCondition build() {
    OperatorCondition buildable = new OperatorCondition(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}