package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UpdateStrategyBuilder extends UpdateStrategyFluentImpl<UpdateStrategyBuilder> implements VisitableBuilder<UpdateStrategy,UpdateStrategyBuilder>{
  public UpdateStrategyBuilder() {
    this(false);
  }
  public UpdateStrategyBuilder(Boolean validationEnabled) {
    this(new UpdateStrategy(), validationEnabled);
  }
  public UpdateStrategyBuilder(UpdateStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public UpdateStrategyBuilder(UpdateStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UpdateStrategy(), validationEnabled);
  }
  public UpdateStrategyBuilder(UpdateStrategyFluent<?> fluent,UpdateStrategy instance) {
    this(fluent, instance, false);
  }
  public UpdateStrategyBuilder(UpdateStrategyFluent<?> fluent,UpdateStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRegistryPoll(instance.getRegistryPoll()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UpdateStrategyBuilder(UpdateStrategy instance) {
    this(instance,false);
  }
  public UpdateStrategyBuilder(UpdateStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRegistryPoll(instance.getRegistryPoll()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UpdateStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public UpdateStrategy build() {
    UpdateStrategy buildable = new UpdateStrategy(fluent.getRegistryPoll());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}