package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StrategyDeploymentPermissionsBuilder extends StrategyDeploymentPermissionsFluentImpl<StrategyDeploymentPermissionsBuilder> implements VisitableBuilder<StrategyDeploymentPermissions,StrategyDeploymentPermissionsBuilder>{
  public StrategyDeploymentPermissionsBuilder() {
    this(false);
  }
  public StrategyDeploymentPermissionsBuilder(Boolean validationEnabled) {
    this(new StrategyDeploymentPermissions(), validationEnabled);
  }
  public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissionsFluent<?> fluent) {
    this(fluent, false);
  }
  public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StrategyDeploymentPermissions(), validationEnabled);
  }
  public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissionsFluent<?> fluent,StrategyDeploymentPermissions instance) {
    this(fluent, instance, false);
  }
  public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissionsFluent<?> fluent,StrategyDeploymentPermissions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRules(instance.getRules()); 
    fluent.withServiceAccountName(instance.getServiceAccountName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissions instance) {
    this(instance,false);
  }
  public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRules(instance.getRules()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StrategyDeploymentPermissionsFluent<?> fluent;
  Boolean validationEnabled;
  public StrategyDeploymentPermissions build() {
    StrategyDeploymentPermissions buildable = new StrategyDeploymentPermissions(fluent.getRules(),fluent.getServiceAccountName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}