package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorGroupBuilder extends OperatorGroupFluentImpl<OperatorGroupBuilder> implements VisitableBuilder<OperatorGroup,OperatorGroupBuilder>{
  public OperatorGroupBuilder() {
    this(false);
  }
  public OperatorGroupBuilder(Boolean validationEnabled) {
    this(new OperatorGroup(), validationEnabled);
  }
  public OperatorGroupBuilder(OperatorGroupFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorGroupBuilder(OperatorGroupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorGroup(), validationEnabled);
  }
  public OperatorGroupBuilder(OperatorGroupFluent<?> fluent,OperatorGroup instance) {
    this(fluent, instance, false);
  }
  public OperatorGroupBuilder(OperatorGroupFluent<?> fluent,OperatorGroup instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorGroupBuilder(OperatorGroup instance) {
    this(instance,false);
  }
  public OperatorGroupBuilder(OperatorGroup instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperatorGroupFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorGroup build() {
    OperatorGroup buildable = new OperatorGroup(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}