package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.model.Condition;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OperatorGroupStatusFluentImpl<A extends OperatorGroupStatusFluent<A>> extends BaseFluent<A> implements OperatorGroupStatusFluent<A>{
  public OperatorGroupStatusFluentImpl() {
  }
  public OperatorGroupStatusFluentImpl(OperatorGroupStatus instance) {
    this.withConditions(instance.getConditions()); 
    this.withLastUpdated(instance.getLastUpdated()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withServiceAccountRef(instance.getServiceAccountRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private String lastUpdated;
  private List<String> namespaces = new ArrayList<String>();
  private ObjectReferenceBuilder serviceAccountRef;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(Integer index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public String getLastUpdated() {
    return this.lastUpdated;
  }
  public A withLastUpdated(String lastUpdated) {
    this.lastUpdated=lastUpdated; return (A) this;
  }
  public Boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  public A addToNamespaces(Integer index,String item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    this.namespaces.add(index, item);
    return (A)this;
  }
  public A setToNamespaces(Integer index,String item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    this.namespaces.set(index, item); return (A)this;
  }
  public A addToNamespaces(java.lang.String... items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    for (String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A addAllToNamespaces(Collection<String> items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<String>();}
    for (String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A removeFromNamespaces(java.lang.String... items) {
    for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
  }
  public A removeAllFromNamespaces(Collection<String> items) {
    for (String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
  }
  public List<String> getNamespaces() {
    return this.namespaces;
  }
  public String getNamespace(Integer index) {
    return this.namespaces.get(index);
  }
  public String getFirstNamespace() {
    return this.namespaces.get(0);
  }
  public String getLastNamespace() {
    return this.namespaces.get(namespaces.size() - 1);
  }
  public String getMatchingNamespace(Predicate<String> predicate) {
    for (String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNamespace(Predicate<String> predicate) {
    for (String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNamespaces(List<String> namespaces) {
    if (namespaces != null) {this.namespaces = new ArrayList(); for (String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
  }
  public A withNamespaces(java.lang.String... namespaces) {
    if (this.namespaces != null) {this.namespaces.clear();}
    if (namespaces != null) {for (String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
  }
  public Boolean hasNamespaces() {
    return namespaces != null && !namespaces.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccountRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getServiceAccountRef() {
    return this.serviceAccountRef!=null ?this.serviceAccountRef.build():null;
  }
  public ObjectReference buildServiceAccountRef() {
    return this.serviceAccountRef!=null ?this.serviceAccountRef.build():null;
  }
  public A withServiceAccountRef(ObjectReference serviceAccountRef) {
    _visitables.get("serviceAccountRef").remove(this.serviceAccountRef);
    if (serviceAccountRef!=null){ this.serviceAccountRef= new ObjectReferenceBuilder(serviceAccountRef); _visitables.get("serviceAccountRef").add(this.serviceAccountRef);} else { this.serviceAccountRef = null; _visitables.get("serviceAccountRef").remove(this.serviceAccountRef); } return (A) this;
  }
  public Boolean hasServiceAccountRef() {
    return this.serviceAccountRef != null;
  }
  public OperatorGroupStatusFluent.ServiceAccountRefNested<A> withNewServiceAccountRef() {
    return new OperatorGroupStatusFluentImpl.ServiceAccountRefNestedImpl();
  }
  public OperatorGroupStatusFluent.ServiceAccountRefNested<A> withNewServiceAccountRefLike(ObjectReference item) {
    return new OperatorGroupStatusFluentImpl.ServiceAccountRefNestedImpl(item);
  }
  public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editServiceAccountRef() {
    return withNewServiceAccountRefLike(getServiceAccountRef());
  }
  public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editOrNewServiceAccountRef() {
    return withNewServiceAccountRefLike(getServiceAccountRef() != null ? getServiceAccountRef(): new ObjectReferenceBuilder().build());
  }
  public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editOrNewServiceAccountRefLike(ObjectReference item) {
    return withNewServiceAccountRefLike(getServiceAccountRef() != null ? getServiceAccountRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OperatorGroupStatusFluentImpl that = (OperatorGroupStatusFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (lastUpdated != null ? !lastUpdated.equals(that.lastUpdated) :that.lastUpdated != null) return false;
    if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
    if (serviceAccountRef != null ? !serviceAccountRef.equals(that.serviceAccountRef) :that.serviceAccountRef != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  lastUpdated,  namespaces,  serviceAccountRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (lastUpdated != null) { sb.append("lastUpdated:"); sb.append(lastUpdated + ","); }
    if (namespaces != null && !namespaces.isEmpty()) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (serviceAccountRef != null) { sb.append("serviceAccountRef:"); sb.append(serviceAccountRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ServiceAccountRefNestedImpl<N> extends ObjectReferenceFluentImpl<OperatorGroupStatusFluent.ServiceAccountRefNested<N>> implements OperatorGroupStatusFluent.ServiceAccountRefNested<N>,Nested<N>{
    ServiceAccountRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ServiceAccountRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) OperatorGroupStatusFluentImpl.this.withServiceAccountRef(builder.build());
    }
    public N endServiceAccountRef() {
      return and();
    }
    
  }
  
}