/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.VSphereCSIDriverConfigSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class VSphereCSIDriverConfigSpecFluent<A extends VSphereCSIDriverConfigSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Long globalMaxSnapshotsPerBlockVolume;
    private Long granularMaxSnapshotsPerBlockVolumeInVSAN;
    private Long granularMaxSnapshotsPerBlockVolumeInVVOL;
    private Integer maxAllowedBlockVolumesPerNode;
    private List<String> topologyCategories = new ArrayList<String>();

    public VSphereCSIDriverConfigSpecFluent() {
    }

    public VSphereCSIDriverConfigSpecFluent(VSphereCSIDriverConfigSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToTopologyCategories(Collection<String> items) {
        if (this.topologyCategories == null) {
            this.topologyCategories = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyCategories.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTopologyCategories(String ... items) {
        if (this.topologyCategories == null) {
            this.topologyCategories = new ArrayList<String>();
        }
        for (String item : items) {
            this.topologyCategories.add(item);
        }
        return (A)((Object)this);
    }

    public A addToTopologyCategories(int index, String item) {
        if (this.topologyCategories == null) {
            this.topologyCategories = new ArrayList<String>();
        }
        this.topologyCategories.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(VSphereCSIDriverConfigSpec instance) {
        VSphereCSIDriverConfigSpec vSphereCSIDriverConfigSpec = instance = instance != null ? instance : new VSphereCSIDriverConfigSpec();
        if (instance != null) {
            this.withGlobalMaxSnapshotsPerBlockVolume(instance.getGlobalMaxSnapshotsPerBlockVolume());
            this.withGranularMaxSnapshotsPerBlockVolumeInVSAN(instance.getGranularMaxSnapshotsPerBlockVolumeInVSAN());
            this.withGranularMaxSnapshotsPerBlockVolumeInVVOL(instance.getGranularMaxSnapshotsPerBlockVolumeInVVOL());
            this.withMaxAllowedBlockVolumesPerNode(instance.getMaxAllowedBlockVolumesPerNode());
            this.withTopologyCategories(instance.getTopologyCategories());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VSphereCSIDriverConfigSpecFluent that = (VSphereCSIDriverConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.globalMaxSnapshotsPerBlockVolume, that.globalMaxSnapshotsPerBlockVolume)) {
            return false;
        }
        if (!Objects.equals(this.granularMaxSnapshotsPerBlockVolumeInVSAN, that.granularMaxSnapshotsPerBlockVolumeInVSAN)) {
            return false;
        }
        if (!Objects.equals(this.granularMaxSnapshotsPerBlockVolumeInVVOL, that.granularMaxSnapshotsPerBlockVolumeInVVOL)) {
            return false;
        }
        if (!Objects.equals(this.maxAllowedBlockVolumesPerNode, that.maxAllowedBlockVolumesPerNode)) {
            return false;
        }
        if (!Objects.equals(this.topologyCategories, that.topologyCategories)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstTopologyCategory() {
        return this.topologyCategories.get(0);
    }

    public Long getGlobalMaxSnapshotsPerBlockVolume() {
        return this.globalMaxSnapshotsPerBlockVolume;
    }

    public Long getGranularMaxSnapshotsPerBlockVolumeInVSAN() {
        return this.granularMaxSnapshotsPerBlockVolumeInVSAN;
    }

    public Long getGranularMaxSnapshotsPerBlockVolumeInVVOL() {
        return this.granularMaxSnapshotsPerBlockVolumeInVVOL;
    }

    public String getLastTopologyCategory() {
        return this.topologyCategories.get(this.topologyCategories.size() - 1);
    }

    public String getMatchingTopologyCategory(Predicate<String> predicate) {
        for (String item : this.topologyCategories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Integer getMaxAllowedBlockVolumesPerNode() {
        return this.maxAllowedBlockVolumesPerNode;
    }

    public List<String> getTopologyCategories() {
        return this.topologyCategories;
    }

    public String getTopologyCategory(int index) {
        return this.topologyCategories.get(index);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasGlobalMaxSnapshotsPerBlockVolume() {
        return this.globalMaxSnapshotsPerBlockVolume != null;
    }

    public boolean hasGranularMaxSnapshotsPerBlockVolumeInVSAN() {
        return this.granularMaxSnapshotsPerBlockVolumeInVSAN != null;
    }

    public boolean hasGranularMaxSnapshotsPerBlockVolumeInVVOL() {
        return this.granularMaxSnapshotsPerBlockVolumeInVVOL != null;
    }

    public boolean hasMatchingTopologyCategory(Predicate<String> predicate) {
        for (String item : this.topologyCategories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMaxAllowedBlockVolumesPerNode() {
        return this.maxAllowedBlockVolumesPerNode != null;
    }

    public boolean hasTopologyCategories() {
        return this.topologyCategories != null && !this.topologyCategories.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.globalMaxSnapshotsPerBlockVolume, this.granularMaxSnapshotsPerBlockVolumeInVSAN, this.granularMaxSnapshotsPerBlockVolumeInVVOL, this.maxAllowedBlockVolumesPerNode, this.topologyCategories, this.additionalProperties);
    }

    public A removeAllFromTopologyCategories(Collection<String> items) {
        if (this.topologyCategories == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.topologyCategories.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTopologyCategories(String ... items) {
        if (this.topologyCategories == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.topologyCategories.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToTopologyCategories(int index, String item) {
        if (this.topologyCategories == null) {
            this.topologyCategories = new ArrayList<String>();
        }
        this.topologyCategories.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.globalMaxSnapshotsPerBlockVolume != null) {
            sb.append("globalMaxSnapshotsPerBlockVolume:");
            sb.append(this.globalMaxSnapshotsPerBlockVolume);
            sb.append(",");
        }
        if (this.granularMaxSnapshotsPerBlockVolumeInVSAN != null) {
            sb.append("granularMaxSnapshotsPerBlockVolumeInVSAN:");
            sb.append(this.granularMaxSnapshotsPerBlockVolumeInVSAN);
            sb.append(",");
        }
        if (this.granularMaxSnapshotsPerBlockVolumeInVVOL != null) {
            sb.append("granularMaxSnapshotsPerBlockVolumeInVVOL:");
            sb.append(this.granularMaxSnapshotsPerBlockVolumeInVVOL);
            sb.append(",");
        }
        if (this.maxAllowedBlockVolumesPerNode != null) {
            sb.append("maxAllowedBlockVolumesPerNode:");
            sb.append(this.maxAllowedBlockVolumesPerNode);
            sb.append(",");
        }
        if (this.topologyCategories != null && !this.topologyCategories.isEmpty()) {
            sb.append("topologyCategories:");
            sb.append(this.topologyCategories);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withGlobalMaxSnapshotsPerBlockVolume(Long globalMaxSnapshotsPerBlockVolume) {
        this.globalMaxSnapshotsPerBlockVolume = globalMaxSnapshotsPerBlockVolume;
        return (A)((Object)this);
    }

    public A withGranularMaxSnapshotsPerBlockVolumeInVSAN(Long granularMaxSnapshotsPerBlockVolumeInVSAN) {
        this.granularMaxSnapshotsPerBlockVolumeInVSAN = granularMaxSnapshotsPerBlockVolumeInVSAN;
        return (A)((Object)this);
    }

    public A withGranularMaxSnapshotsPerBlockVolumeInVVOL(Long granularMaxSnapshotsPerBlockVolumeInVVOL) {
        this.granularMaxSnapshotsPerBlockVolumeInVVOL = granularMaxSnapshotsPerBlockVolumeInVVOL;
        return (A)((Object)this);
    }

    public A withMaxAllowedBlockVolumesPerNode(Integer maxAllowedBlockVolumesPerNode) {
        this.maxAllowedBlockVolumesPerNode = maxAllowedBlockVolumesPerNode;
        return (A)((Object)this);
    }

    public A withTopologyCategories(List<String> topologyCategories) {
        if (topologyCategories != null) {
            this.topologyCategories = new ArrayList<String>();
            for (String item : topologyCategories) {
                this.addToTopologyCategories(item);
            }
        } else {
            this.topologyCategories = null;
        }
        return (A)((Object)this);
    }

    public A withTopologyCategories(String ... topologyCategories) {
        if (this.topologyCategories != null) {
            this.topologyCategories.clear();
            this._visitables.remove((Object)"topologyCategories");
        }
        if (topologyCategories != null) {
            for (String item : topologyCategories) {
                this.addToTopologyCategories(item);
            }
        }
        return (A)((Object)this);
    }
}

