/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.SFlowConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SFlowConfigFluent<A extends SFlowConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> collectors = new ArrayList<String>();

    public SFlowConfigFluent() {
    }

    public SFlowConfigFluent(SFlowConfig instance) {
        this.copyInstance(instance);
    }

    public A addAllToCollectors(Collection<String> items) {
        if (this.collectors == null) {
            this.collectors = new ArrayList<String>();
        }
        for (String item : items) {
            this.collectors.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCollectors(String ... items) {
        if (this.collectors == null) {
            this.collectors = new ArrayList<String>();
        }
        for (String item : items) {
            this.collectors.add(item);
        }
        return (A)((Object)this);
    }

    public A addToCollectors(int index, String item) {
        if (this.collectors == null) {
            this.collectors = new ArrayList<String>();
        }
        this.collectors.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(SFlowConfig instance) {
        SFlowConfig sFlowConfig = instance = instance != null ? instance : new SFlowConfig();
        if (instance != null) {
            this.withCollectors(instance.getCollectors());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SFlowConfigFluent that = (SFlowConfigFluent)((Object)o);
        if (!Objects.equals(this.collectors, that.collectors)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getCollector(int index) {
        return this.collectors.get(index);
    }

    public List<String> getCollectors() {
        return this.collectors;
    }

    public String getFirstCollector() {
        return this.collectors.get(0);
    }

    public String getLastCollector() {
        return this.collectors.get(this.collectors.size() - 1);
    }

    public String getMatchingCollector(Predicate<String> predicate) {
        for (String item : this.collectors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCollectors() {
        return this.collectors != null && !this.collectors.isEmpty();
    }

    public boolean hasMatchingCollector(Predicate<String> predicate) {
        for (String item : this.collectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.collectors, this.additionalProperties);
    }

    public A removeAllFromCollectors(Collection<String> items) {
        if (this.collectors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.collectors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromCollectors(String ... items) {
        if (this.collectors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.collectors.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToCollectors(int index, String item) {
        if (this.collectors == null) {
            this.collectors = new ArrayList<String>();
        }
        this.collectors.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.collectors != null && !this.collectors.isEmpty()) {
            sb.append("collectors:");
            sb.append(this.collectors);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCollectors(List<String> collectors) {
        if (collectors != null) {
            this.collectors = new ArrayList<String>();
            for (String item : collectors) {
                this.addToCollectors(item);
            }
        } else {
            this.collectors = null;
        }
        return (A)((Object)this);
    }

    public A withCollectors(String ... collectors) {
        if (this.collectors != null) {
            this.collectors.clear();
            this._visitables.remove((Object)"collectors");
        }
        if (collectors != null) {
            for (String item : collectors) {
                this.addToCollectors(item);
            }
        }
        return (A)((Object)this);
    }
}

