package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StaticIPAMAddressesBuilder extends StaticIPAMAddressesFluent<StaticIPAMAddressesBuilder> implements VisitableBuilder<StaticIPAMAddresses,StaticIPAMAddressesBuilder>{
  public StaticIPAMAddressesBuilder() {
    this(new StaticIPAMAddresses());
  }
  
  public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent) {
    this(fluent, new StaticIPAMAddresses());
  }
  
  public StaticIPAMAddressesBuilder(StaticIPAMAddressesFluent<?> fluent,StaticIPAMAddresses instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StaticIPAMAddressesBuilder(StaticIPAMAddresses instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StaticIPAMAddressesFluent<?> fluent;
  
  public StaticIPAMAddresses build() {
    StaticIPAMAddresses buildable = new StaticIPAMAddresses(fluent.getAddress(),fluent.getGateway());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}