/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AWSCSIDriverConfigSpec;
import io.fabric8.openshift.api.model.operator.v1.AWSCSIDriverConfigSpecBuilder;
import io.fabric8.openshift.api.model.operator.v1.AWSCSIDriverConfigSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.AzureCSIDriverConfigSpec;
import io.fabric8.openshift.api.model.operator.v1.AzureCSIDriverConfigSpecBuilder;
import io.fabric8.openshift.api.model.operator.v1.AzureCSIDriverConfigSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.CSIDriverConfigSpec;
import io.fabric8.openshift.api.model.operator.v1.GCPCSIDriverConfigSpec;
import io.fabric8.openshift.api.model.operator.v1.GCPCSIDriverConfigSpecBuilder;
import io.fabric8.openshift.api.model.operator.v1.GCPCSIDriverConfigSpecFluent;
import io.fabric8.openshift.api.model.operator.v1.VSphereCSIDriverConfigSpec;
import io.fabric8.openshift.api.model.operator.v1.VSphereCSIDriverConfigSpecBuilder;
import io.fabric8.openshift.api.model.operator.v1.VSphereCSIDriverConfigSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CSIDriverConfigSpecFluent<A extends CSIDriverConfigSpecFluent<A>>
extends BaseFluent<A> {
    private AWSCSIDriverConfigSpecBuilder aws;
    private AzureCSIDriverConfigSpecBuilder azure;
    private String driverType;
    private GCPCSIDriverConfigSpecBuilder gcp;
    private VSphereCSIDriverConfigSpecBuilder vSphere;
    private Map<String, Object> additionalProperties;

    public CSIDriverConfigSpecFluent() {
    }

    public CSIDriverConfigSpecFluent(CSIDriverConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CSIDriverConfigSpec instance) {
        CSIDriverConfigSpec cSIDriverConfigSpec = instance = instance != null ? instance : new CSIDriverConfigSpec();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withDriverType(instance.getDriverType());
            this.withGcp(instance.getGcp());
            this.withVSphere(instance.getVSphere());
            this.withAws(instance.getAws());
            this.withAzure(instance.getAzure());
            this.withDriverType(instance.getDriverType());
            this.withGcp(instance.getGcp());
            this.withVSphere(instance.getVSphere());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AWSCSIDriverConfigSpec buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    public A withAws(AWSCSIDriverConfigSpec aws) {
        this._visitables.get((Object)"aws").remove((Object)this.aws);
        if (aws != null) {
            this.aws = new AWSCSIDriverConfigSpecBuilder(aws);
            this._visitables.get((Object)"aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get((Object)"aws").remove((Object)this.aws);
        }
        return (A)((Object)this);
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public A withNewAws(String kmsKeyARN) {
        return this.withAws(new AWSCSIDriverConfigSpec(kmsKeyARN));
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public AwsNested<A> withNewAwsLike(AWSCSIDriverConfigSpec item) {
        return new AwsNested(item);
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new AWSCSIDriverConfigSpecBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(AWSCSIDriverConfigSpec item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public AzureCSIDriverConfigSpec buildAzure() {
        return this.azure != null ? this.azure.build() : null;
    }

    public A withAzure(AzureCSIDriverConfigSpec azure) {
        this._visitables.get((Object)"azure").remove((Object)this.azure);
        if (azure != null) {
            this.azure = new AzureCSIDriverConfigSpecBuilder(azure);
            this._visitables.get((Object)"azure").add(this.azure);
        } else {
            this.azure = null;
            this._visitables.get((Object)"azure").remove((Object)this.azure);
        }
        return (A)((Object)this);
    }

    public boolean hasAzure() {
        return this.azure != null;
    }

    public AzureNested<A> withNewAzure() {
        return new AzureNested(null);
    }

    public AzureNested<A> withNewAzureLike(AzureCSIDriverConfigSpec item) {
        return new AzureNested(item);
    }

    public AzureNested<A> editAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(null));
    }

    public AzureNested<A> editOrNewAzure() {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(new AzureCSIDriverConfigSpecBuilder().build()));
    }

    public AzureNested<A> editOrNewAzureLike(AzureCSIDriverConfigSpec item) {
        return this.withNewAzureLike(Optional.ofNullable(this.buildAzure()).orElse(item));
    }

    public String getDriverType() {
        return this.driverType;
    }

    public A withDriverType(String driverType) {
        this.driverType = driverType;
        return (A)((Object)this);
    }

    public boolean hasDriverType() {
        return this.driverType != null;
    }

    public GCPCSIDriverConfigSpec buildGcp() {
        return this.gcp != null ? this.gcp.build() : null;
    }

    public A withGcp(GCPCSIDriverConfigSpec gcp) {
        this._visitables.get((Object)"gcp").remove((Object)this.gcp);
        if (gcp != null) {
            this.gcp = new GCPCSIDriverConfigSpecBuilder(gcp);
            this._visitables.get((Object)"gcp").add(this.gcp);
        } else {
            this.gcp = null;
            this._visitables.get((Object)"gcp").remove((Object)this.gcp);
        }
        return (A)((Object)this);
    }

    public boolean hasGcp() {
        return this.gcp != null;
    }

    public GcpNested<A> withNewGcp() {
        return new GcpNested(null);
    }

    public GcpNested<A> withNewGcpLike(GCPCSIDriverConfigSpec item) {
        return new GcpNested(item);
    }

    public GcpNested<A> editGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(null));
    }

    public GcpNested<A> editOrNewGcp() {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(new GCPCSIDriverConfigSpecBuilder().build()));
    }

    public GcpNested<A> editOrNewGcpLike(GCPCSIDriverConfigSpec item) {
        return this.withNewGcpLike(Optional.ofNullable(this.buildGcp()).orElse(item));
    }

    public VSphereCSIDriverConfigSpec buildVSphere() {
        return this.vSphere != null ? this.vSphere.build() : null;
    }

    public A withVSphere(VSphereCSIDriverConfigSpec vSphere) {
        this._visitables.get((Object)"vSphere").remove((Object)this.vSphere);
        if (vSphere != null) {
            this.vSphere = new VSphereCSIDriverConfigSpecBuilder(vSphere);
            this._visitables.get((Object)"vSphere").add(this.vSphere);
        } else {
            this.vSphere = null;
            this._visitables.get((Object)"vSphere").remove((Object)this.vSphere);
        }
        return (A)((Object)this);
    }

    public boolean hasVSphere() {
        return this.vSphere != null;
    }

    public VSphereNested<A> withNewVSphere() {
        return new VSphereNested(null);
    }

    public VSphereNested<A> withNewVSphereLike(VSphereCSIDriverConfigSpec item) {
        return new VSphereNested(item);
    }

    public VSphereNested<A> editVSphere() {
        return this.withNewVSphereLike(Optional.ofNullable(this.buildVSphere()).orElse(null));
    }

    public VSphereNested<A> editOrNewVSphere() {
        return this.withNewVSphereLike(Optional.ofNullable(this.buildVSphere()).orElse(new VSphereCSIDriverConfigSpecBuilder().build()));
    }

    public VSphereNested<A> editOrNewVSphereLike(VSphereCSIDriverConfigSpec item) {
        return this.withNewVSphereLike(Optional.ofNullable(this.buildVSphere()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSIDriverConfigSpecFluent that = (CSIDriverConfigSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.aws, (Object)that.aws)) {
            return false;
        }
        if (!Objects.equals((Object)this.azure, (Object)that.azure)) {
            return false;
        }
        if (!Objects.equals(this.driverType, that.driverType)) {
            return false;
        }
        if (!Objects.equals((Object)this.gcp, (Object)that.gcp)) {
            return false;
        }
        if (!Objects.equals((Object)this.vSphere, (Object)that.vSphere)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aws, this.azure, this.driverType, this.gcp, this.vSphere, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append((Object)((Object)this.aws) + ",");
        }
        if (this.azure != null) {
            sb.append("azure:");
            sb.append((Object)((Object)this.azure) + ",");
        }
        if (this.driverType != null) {
            sb.append("driverType:");
            sb.append(this.driverType + ",");
        }
        if (this.gcp != null) {
            sb.append("gcp:");
            sb.append((Object)((Object)this.gcp) + ",");
        }
        if (this.vSphere != null) {
            sb.append("vSphere:");
            sb.append((Object)((Object)this.vSphere) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VSphereNested<N>
    extends VSphereCSIDriverConfigSpecFluent<VSphereNested<N>>
    implements Nested<N> {
        VSphereCSIDriverConfigSpecBuilder builder;

        VSphereNested(VSphereCSIDriverConfigSpec item) {
            this.builder = new VSphereCSIDriverConfigSpecBuilder(this, item);
        }

        public N and() {
            return (N)CSIDriverConfigSpecFluent.this.withVSphere(this.builder.build());
        }

        public N endVSphere() {
            return this.and();
        }
    }

    public class GcpNested<N>
    extends GCPCSIDriverConfigSpecFluent<GcpNested<N>>
    implements Nested<N> {
        GCPCSIDriverConfigSpecBuilder builder;

        GcpNested(GCPCSIDriverConfigSpec item) {
            this.builder = new GCPCSIDriverConfigSpecBuilder(this, item);
        }

        public N and() {
            return (N)CSIDriverConfigSpecFluent.this.withGcp(this.builder.build());
        }

        public N endGcp() {
            return this.and();
        }
    }

    public class AzureNested<N>
    extends AzureCSIDriverConfigSpecFluent<AzureNested<N>>
    implements Nested<N> {
        AzureCSIDriverConfigSpecBuilder builder;

        AzureNested(AzureCSIDriverConfigSpec item) {
            this.builder = new AzureCSIDriverConfigSpecBuilder(this, item);
        }

        public N and() {
            return (N)CSIDriverConfigSpecFluent.this.withAzure(this.builder.build());
        }

        public N endAzure() {
            return this.and();
        }
    }

    public class AwsNested<N>
    extends AWSCSIDriverConfigSpecFluent<AwsNested<N>>
    implements Nested<N> {
        AWSCSIDriverConfigSpecBuilder builder;

        AwsNested(AWSCSIDriverConfigSpec item) {
            this.builder = new AWSCSIDriverConfigSpecBuilder(this, item);
        }

        public N and() {
            return (N)CSIDriverConfigSpecFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

