/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.ForwardPlugin;
import io.fabric8.openshift.api.model.operator.v1.ForwardPluginFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ForwardPluginFluentImpl<A extends ForwardPluginFluent<A>>
extends BaseFluent<A>
implements ForwardPluginFluent<A> {
    private String policy;
    private List<String> upstreams = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ForwardPluginFluentImpl() {
    }

    public ForwardPluginFluentImpl(ForwardPlugin instance) {
        if (instance != null) {
            this.withPolicy(instance.getPolicy());
            this.withUpstreams(instance.getUpstreams());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getPolicy() {
        return this.policy;
    }

    @Override
    public A withPolicy(String policy) {
        this.policy = policy;
        return (A)this;
    }

    @Override
    public Boolean hasPolicy() {
        return this.policy != null;
    }

    @Override
    public A addToUpstreams(int index, String item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        this.upstreams.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUpstreams(int index, String item) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        this.upstreams.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUpstreams(String ... items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        for (String item : items) {
            this.upstreams.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUpstreams(Collection<String> items) {
        if (this.upstreams == null) {
            this.upstreams = new ArrayList<String>();
        }
        for (String item : items) {
            this.upstreams.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUpstreams(String ... items) {
        for (String item : items) {
            if (this.upstreams == null) continue;
            this.upstreams.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUpstreams(Collection<String> items) {
        for (String item : items) {
            if (this.upstreams == null) continue;
            this.upstreams.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUpstreams() {
        return this.upstreams;
    }

    @Override
    public String getUpstream(int index) {
        return this.upstreams.get(index);
    }

    @Override
    public String getFirstUpstream() {
        return this.upstreams.get(0);
    }

    @Override
    public String getLastUpstream() {
        return this.upstreams.get(this.upstreams.size() - 1);
    }

    @Override
    public String getMatchingUpstream(Predicate<String> predicate) {
        for (String item : this.upstreams) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingUpstream(Predicate<String> predicate) {
        for (String item : this.upstreams) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withUpstreams(List<String> upstreams) {
        if (upstreams != null) {
            this.upstreams = new ArrayList<String>();
            for (String item : upstreams) {
                this.addToUpstreams(item);
            }
        } else {
            this.upstreams = null;
        }
        return (A)this;
    }

    @Override
    public A withUpstreams(String ... upstreams) {
        if (this.upstreams != null) {
            this.upstreams.clear();
            this._visitables.remove((Object)"upstreams");
        }
        if (upstreams != null) {
            for (String item : upstreams) {
                this.addToUpstreams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpstreams() {
        return this.upstreams != null && !this.upstreams.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ForwardPluginFluentImpl that = (ForwardPluginFluentImpl)o;
        if (!Objects.equals(this.policy, that.policy)) {
            return false;
        }
        if (!Objects.equals(this.upstreams, that.upstreams)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.policy, this.upstreams, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policy != null) {
            sb.append("policy:");
            sb.append(this.policy + ",");
        }
        if (this.upstreams != null && !this.upstreams.isEmpty()) {
            sb.append("upstreams:");
            sb.append(this.upstreams + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

