package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCatalogControllerManagerListBuilder extends ServiceCatalogControllerManagerListFluentImpl<ServiceCatalogControllerManagerListBuilder> implements VisitableBuilder<ServiceCatalogControllerManagerList,ServiceCatalogControllerManagerListBuilder>{
  public ServiceCatalogControllerManagerListBuilder() {
    this(false);
  }
  public ServiceCatalogControllerManagerListBuilder(Boolean validationEnabled) {
    this(new ServiceCatalogControllerManagerList(), validationEnabled);
  }
  public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCatalogControllerManagerList(), validationEnabled);
  }
  public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerListFluent<?> fluent,ServiceCatalogControllerManagerList instance) {
    this(fluent, instance, false);
  }
  public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerListFluent<?> fluent,ServiceCatalogControllerManagerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerList instance) {
    this(instance,false);
  }
  public ServiceCatalogControllerManagerListBuilder(ServiceCatalogControllerManagerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ServiceCatalogControllerManagerListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCatalogControllerManagerList build() {
    ServiceCatalogControllerManagerList buildable = new ServiceCatalogControllerManagerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}