package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteAdmissionPolicyBuilder extends RouteAdmissionPolicyFluentImpl<RouteAdmissionPolicyBuilder> implements VisitableBuilder<RouteAdmissionPolicy,RouteAdmissionPolicyBuilder>{
  public RouteAdmissionPolicyBuilder() {
    this(false);
  }
  public RouteAdmissionPolicyBuilder(Boolean validationEnabled) {
    this(new RouteAdmissionPolicy(), validationEnabled);
  }
  public RouteAdmissionPolicyBuilder(RouteAdmissionPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteAdmissionPolicyBuilder(RouteAdmissionPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteAdmissionPolicy(), validationEnabled);
  }
  public RouteAdmissionPolicyBuilder(RouteAdmissionPolicyFluent<?> fluent,RouteAdmissionPolicy instance) {
    this(fluent, instance, false);
  }
  public RouteAdmissionPolicyBuilder(RouteAdmissionPolicyFluent<?> fluent,RouteAdmissionPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNamespaceOwnership(instance.getNamespaceOwnership()); 
    fluent.withWildcardPolicy(instance.getWildcardPolicy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteAdmissionPolicyBuilder(RouteAdmissionPolicy instance) {
    this(instance,false);
  }
  public RouteAdmissionPolicyBuilder(RouteAdmissionPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNamespaceOwnership(instance.getNamespaceOwnership()); 
    this.withWildcardPolicy(instance.getWildcardPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RouteAdmissionPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public RouteAdmissionPolicy build() {
    RouteAdmissionPolicy buildable = new RouteAdmissionPolicy(fluent.getNamespaceOwnership(),fluent.getWildcardPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}