package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetFlowConfigFluentImpl<A extends NetFlowConfigFluent<A>> extends BaseFluent<A> implements NetFlowConfigFluent<A>{
  public NetFlowConfigFluentImpl() {
  }
  public NetFlowConfigFluentImpl(NetFlowConfig instance) {
    this.withCollectors(instance.getCollectors()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> collectors = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToCollectors(Integer index,String item) {
    if (this.collectors == null) {this.collectors = new ArrayList<String>();}
    this.collectors.add(index, item);
    return (A)this;
  }
  public A setToCollectors(Integer index,String item) {
    if (this.collectors == null) {this.collectors = new ArrayList<String>();}
    this.collectors.set(index, item); return (A)this;
  }
  public A addToCollectors(java.lang.String... items) {
    if (this.collectors == null) {this.collectors = new ArrayList<String>();}
    for (String item : items) {this.collectors.add(item);} return (A)this;
  }
  public A addAllToCollectors(Collection<String> items) {
    if (this.collectors == null) {this.collectors = new ArrayList<String>();}
    for (String item : items) {this.collectors.add(item);} return (A)this;
  }
  public A removeFromCollectors(java.lang.String... items) {
    for (String item : items) {if (this.collectors!= null){ this.collectors.remove(item);}} return (A)this;
  }
  public A removeAllFromCollectors(Collection<String> items) {
    for (String item : items) {if (this.collectors!= null){ this.collectors.remove(item);}} return (A)this;
  }
  public List<String> getCollectors() {
    return this.collectors;
  }
  public String getCollector(Integer index) {
    return this.collectors.get(index);
  }
  public String getFirstCollector() {
    return this.collectors.get(0);
  }
  public String getLastCollector() {
    return this.collectors.get(collectors.size() - 1);
  }
  public String getMatchingCollector(Predicate<String> predicate) {
    for (String item: collectors) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCollector(Predicate<String> predicate) {
    for (String item: collectors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCollectors(List<String> collectors) {
    if (collectors != null) {this.collectors = new ArrayList(); for (String item : collectors){this.addToCollectors(item);}} else { this.collectors = null;} return (A) this;
  }
  public A withCollectors(java.lang.String... collectors) {
    if (this.collectors != null) {this.collectors.clear();}
    if (collectors != null) {for (String item :collectors){ this.addToCollectors(item);}} return (A) this;
  }
  public Boolean hasCollectors() {
    return collectors != null && !collectors.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetFlowConfigFluentImpl that = (NetFlowConfigFluentImpl) o;
    if (collectors != null ? !collectors.equals(that.collectors) :that.collectors != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(collectors,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (collectors != null && !collectors.isEmpty()) { sb.append("collectors:"); sb.append(collectors + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}