package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.config.v1.TLSProfileSpec;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressControllerStatusFluentImpl<A extends IngressControllerStatusFluent<A>> extends BaseFluent<A> implements IngressControllerStatusFluent<A>{
  public IngressControllerStatusFluentImpl() {
  }
  public IngressControllerStatusFluentImpl(IngressControllerStatus instance) {
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withDomain(instance.getDomain()); 
    this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withSelector(instance.getSelector()); 
    this.withTlsProfile(instance.getTlsProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer availableReplicas;
  private ArrayList<OperatorConditionBuilder> conditions = new ArrayList<OperatorConditionBuilder>();
  private String domain;
  private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
  private Long observedGeneration;
  private String selector;
  private TLSProfileSpec tlsProfile;
  private Map<String,Object> additionalProperties;
  public Integer getAvailableReplicas() {
    return this.availableReplicas;
  }
  public A withAvailableReplicas(Integer availableReplicas) {
    this.availableReplicas=availableReplicas; return (A) this;
  }
  public Boolean hasAvailableReplicas() {
    return this.availableReplicas != null;
  }
  public A addToConditions(Integer index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,OperatorCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<OperatorCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<OperatorConditionBuilder>();}
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... items) {
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<OperatorCondition> items) {
    for (OperatorCondition item : items) {OperatorConditionBuilder builder = new OperatorConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<OperatorConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      OperatorConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<OperatorCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<OperatorCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public OperatorCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public OperatorCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public OperatorCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    for (OperatorConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    for (OperatorConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<OperatorCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (OperatorCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.operator.v1.OperatorCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (OperatorCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  public IngressControllerStatusFluent.ConditionsNested<A> addNewCondition() {
    return new IngressControllerStatusFluentImpl.ConditionsNestedImpl();
  }
  public IngressControllerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
    return new IngressControllerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public IngressControllerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,OperatorCondition item) {
    return new IngressControllerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public IngressControllerStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IngressControllerStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public IngressControllerStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IngressControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getDomain() {
    return this.domain;
  }
  public A withDomain(String domain) {
    this.domain=domain; return (A) this;
  }
  public Boolean hasDomain() {
    return this.domain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpointPublishingStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public EndpointPublishingStrategy getEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null ?this.endpointPublishingStrategy.build():null;
  }
  public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null ?this.endpointPublishingStrategy.build():null;
  }
  public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
    _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
    if (endpointPublishingStrategy!=null){ this.endpointPublishingStrategy= new EndpointPublishingStrategyBuilder(endpointPublishingStrategy); _visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);} else { this.endpointPublishingStrategy = null; _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy); } return (A) this;
  }
  public Boolean hasEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy != null;
  }
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
    return new IngressControllerStatusFluentImpl.EndpointPublishingStrategyNestedImpl();
  }
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return new IngressControllerStatusFluentImpl.EndpointPublishingStrategyNestedImpl(item);
  }
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy());
  }
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): new EndpointPublishingStrategyBuilder().build());
  }
  public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return withNewEndpointPublishingStrategyLike(getEndpointPublishingStrategy() != null ? getEndpointPublishingStrategy(): item);
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public String getSelector() {
    return this.selector;
  }
  public A withSelector(String selector) {
    this.selector=selector; return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public TLSProfileSpec getTlsProfile() {
    return this.tlsProfile;
  }
  public A withTlsProfile(TLSProfileSpec tlsProfile) {
    this.tlsProfile=tlsProfile; return (A) this;
  }
  public Boolean hasTlsProfile() {
    return this.tlsProfile != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressControllerStatusFluentImpl that = (IngressControllerStatusFluentImpl) o;
    if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (domain != null ? !domain.equals(that.domain) :that.domain != null) return false;
    if (endpointPublishingStrategy != null ? !endpointPublishingStrategy.equals(that.endpointPublishingStrategy) :that.endpointPublishingStrategy != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (tlsProfile != null ? !tlsProfile.equals(that.tlsProfile) :that.tlsProfile != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableReplicas,  conditions,  domain,  endpointPublishingStrategy,  observedGeneration,  selector,  tlsProfile,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableReplicas != null) { sb.append("availableReplicas:"); sb.append(availableReplicas + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (endpointPublishingStrategy != null) { sb.append("endpointPublishingStrategy:"); sb.append(endpointPublishingStrategy + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (tlsProfile != null) { sb.append("tlsProfile:"); sb.append(tlsProfile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends OperatorConditionFluentImpl<IngressControllerStatusFluent.ConditionsNested<N>> implements IngressControllerStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,OperatorCondition item) {
      this.index = index;
      this.builder = new OperatorConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new OperatorConditionBuilder(this);
    }
    OperatorConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) IngressControllerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class EndpointPublishingStrategyNestedImpl<N> extends EndpointPublishingStrategyFluentImpl<IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>> implements IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>,Nested<N>{
    EndpointPublishingStrategyNestedImpl(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyNestedImpl() {
      this.builder = new EndpointPublishingStrategyBuilder(this);
    }
    EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerStatusFluentImpl.this.withEndpointPublishingStrategy(builder.build());
    }
    public N endEndpointPublishingStrategy() {
      return and();
    }
    
  }
  
}