package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressControllerCaptureHTTPCookieBuilder extends IngressControllerCaptureHTTPCookieFluentImpl<IngressControllerCaptureHTTPCookieBuilder> implements VisitableBuilder<IngressControllerCaptureHTTPCookie,IngressControllerCaptureHTTPCookieBuilder>{
  public IngressControllerCaptureHTTPCookieBuilder() {
    this(false);
  }
  public IngressControllerCaptureHTTPCookieBuilder(Boolean validationEnabled) {
    this(new IngressControllerCaptureHTTPCookie(), validationEnabled);
  }
  public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookieFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookieFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressControllerCaptureHTTPCookie(), validationEnabled);
  }
  public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookieFluent<?> fluent,IngressControllerCaptureHTTPCookie instance) {
    this(fluent, instance, false);
  }
  public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookieFluent<?> fluent,IngressControllerCaptureHTTPCookie instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatchType(instance.getMatchType()); 
    fluent.withMaxLength(instance.getMaxLength()); 
    fluent.withName(instance.getName()); 
    fluent.withNamePrefix(instance.getNamePrefix()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookie instance) {
    this(instance,false);
  }
  public IngressControllerCaptureHTTPCookieBuilder(IngressControllerCaptureHTTPCookie instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatchType(instance.getMatchType()); 
    this.withMaxLength(instance.getMaxLength()); 
    this.withName(instance.getName()); 
    this.withNamePrefix(instance.getNamePrefix()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressControllerCaptureHTTPCookieFluent<?> fluent;
  Boolean validationEnabled;
  public IngressControllerCaptureHTTPCookie build() {
    IngressControllerCaptureHTTPCookie buildable = new IngressControllerCaptureHTTPCookie(fluent.getMatchType(),fluent.getMaxLength(),fluent.getName(),fluent.getNamePrefix());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}