/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.ForwardPlugin;
import io.fabric8.openshift.api.model.operator.v1.ForwardPluginBuilder;
import io.fabric8.openshift.api.model.operator.v1.ForwardPluginFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.Server;
import io.fabric8.openshift.api.model.operator.v1.ServerFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ServerFluentImpl<A extends ServerFluent<A>>
extends BaseFluent<A>
implements ServerFluent<A> {
    private ForwardPluginBuilder forwardPlugin;
    private String name;
    private List<String> zones = new ArrayList<String>();

    public ServerFluentImpl() {
    }

    public ServerFluentImpl(Server instance) {
        this.withForwardPlugin(instance.getForwardPlugin());
        this.withName(instance.getName());
        this.withZones(instance.getZones());
    }

    @Override
    @Deprecated
    public ForwardPlugin getForwardPlugin() {
        return this.forwardPlugin != null ? this.forwardPlugin.build() : null;
    }

    @Override
    public ForwardPlugin buildForwardPlugin() {
        return this.forwardPlugin != null ? this.forwardPlugin.build() : null;
    }

    @Override
    public A withForwardPlugin(ForwardPlugin forwardPlugin) {
        this._visitables.get((Object)"forwardPlugin").remove(this.forwardPlugin);
        if (forwardPlugin != null) {
            this.forwardPlugin = new ForwardPluginBuilder(forwardPlugin);
            this._visitables.get((Object)"forwardPlugin").add(this.forwardPlugin);
        }
        return (A)this;
    }

    @Override
    public Boolean hasForwardPlugin() {
        return this.forwardPlugin != null;
    }

    @Override
    public ServerFluent.ForwardPluginNested<A> withNewForwardPlugin() {
        return new ForwardPluginNestedImpl();
    }

    @Override
    public ServerFluent.ForwardPluginNested<A> withNewForwardPluginLike(ForwardPlugin item) {
        return new ForwardPluginNestedImpl(item);
    }

    @Override
    public ServerFluent.ForwardPluginNested<A> editForwardPlugin() {
        return this.withNewForwardPluginLike(this.getForwardPlugin());
    }

    @Override
    public ServerFluent.ForwardPluginNested<A> editOrNewForwardPlugin() {
        return this.withNewForwardPluginLike(this.getForwardPlugin() != null ? this.getForwardPlugin() : new ForwardPluginBuilder().build());
    }

    @Override
    public ServerFluent.ForwardPluginNested<A> editOrNewForwardPluginLike(ForwardPlugin item) {
        return this.withNewForwardPluginLike(this.getForwardPlugin() != null ? this.getForwardPlugin() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public A addToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    @Override
    public A setToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    @Override
    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromZones(String ... items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromZones(Collection<String> items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getZones() {
        return this.zones;
    }

    @Override
    public String getZone(Integer index) {
        return this.zones.get(index);
    }

    @Override
    public String getFirstZone() {
        return this.zones.get(0);
    }

    @Override
    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    @Override
    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    @Override
    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public A addNewZone(String arg0) {
        return this.addToZones(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerFluentImpl that = (ServerFluentImpl)o;
        if (this.forwardPlugin != null ? !this.forwardPlugin.equals(that.forwardPlugin) : that.forwardPlugin != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.zones != null ? !this.zones.equals(that.zones) : that.zones != null);
    }

    public int hashCode() {
        return Objects.hash(this.forwardPlugin, this.name, this.zones, super.hashCode());
    }

    public class ForwardPluginNestedImpl<N>
    extends ForwardPluginFluentImpl<ServerFluent.ForwardPluginNested<N>>
    implements ServerFluent.ForwardPluginNested<N>,
    Nested<N> {
        ForwardPluginBuilder builder;

        ForwardPluginNestedImpl(ForwardPlugin item) {
            this.builder = new ForwardPluginBuilder(this, item);
        }

        ForwardPluginNestedImpl() {
            this.builder = new ForwardPluginBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServerFluentImpl.this.withForwardPlugin(this.builder.build());
        }

        @Override
        public N endForwardPlugin() {
            return this.and();
        }
    }
}

