/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.Console;
import io.fabric8.openshift.api.model.operator.v1.ConsoleFluent;
import io.fabric8.openshift.api.model.operator.v1.ConsoleSpec;
import io.fabric8.openshift.api.model.operator.v1.ConsoleSpecBuilder;
import io.fabric8.openshift.api.model.operator.v1.ConsoleSpecFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.ConsoleStatus;
import io.fabric8.openshift.api.model.operator.v1.ConsoleStatusBuilder;
import io.fabric8.openshift.api.model.operator.v1.ConsoleStatusFluentImpl;
import java.util.Objects;

public class ConsoleFluentImpl<A extends ConsoleFluent<A>>
extends BaseFluent<A>
implements ConsoleFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ConsoleSpecBuilder spec;
    private ConsoleStatusBuilder status;

    public ConsoleFluentImpl() {
    }

    public ConsoleFluentImpl(Console instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ConsoleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ConsoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ConsoleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ConsoleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ConsoleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ConsoleSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ConsoleSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ConsoleSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ConsoleSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ConsoleFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ConsoleFluent.SpecNested<A> withNewSpecLike(ConsoleSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ConsoleFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ConsoleFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ConsoleSpecBuilder().build());
    }

    @Override
    public ConsoleFluent.SpecNested<A> editOrNewSpecLike(ConsoleSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ConsoleStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ConsoleStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ConsoleStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new ConsoleStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ConsoleFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ConsoleFluent.StatusNested<A> withNewStatusLike(ConsoleStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ConsoleFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ConsoleFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ConsoleStatusBuilder().build());
    }

    @Override
    public ConsoleFluent.StatusNested<A> editOrNewStatusLike(ConsoleStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsoleFluentImpl that = (ConsoleFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends ConsoleStatusFluentImpl<ConsoleFluent.StatusNested<N>>
    implements ConsoleFluent.StatusNested<N>,
    Nested<N> {
        ConsoleStatusBuilder builder;

        StatusNestedImpl(ConsoleStatus item) {
            this.builder = new ConsoleStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ConsoleStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ConsoleSpecFluentImpl<ConsoleFluent.SpecNested<N>>
    implements ConsoleFluent.SpecNested<N>,
    Nested<N> {
        ConsoleSpecBuilder builder;

        SpecNestedImpl(ConsoleSpec item) {
            this.builder = new ConsoleSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ConsoleSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ConsoleFluent.MetadataNested<N>>
    implements ConsoleFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)ConsoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

