/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.Etcd;
import io.fabric8.openshift.api.model.operator.v1.EtcdFluent;
import io.fabric8.openshift.api.model.operator.v1.EtcdFluentImpl;
import java.util.Objects;

public class EtcdBuilder
extends EtcdFluentImpl<EtcdBuilder>
implements VisitableBuilder<Etcd, EtcdBuilder> {
    EtcdFluent<?> fluent;
    Boolean validationEnabled;

    public EtcdBuilder() {
        this(false);
    }

    public EtcdBuilder(Boolean validationEnabled) {
        this(new Etcd(), validationEnabled);
    }

    public EtcdBuilder(EtcdFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public EtcdBuilder(EtcdFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Etcd(), validationEnabled);
    }

    public EtcdBuilder(EtcdFluent<?> fluent, Etcd instance) {
        this(fluent, instance, false);
    }

    public EtcdBuilder(EtcdFluent<?> fluent, Etcd instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public EtcdBuilder(Etcd instance) {
        this(instance, (Boolean)false);
    }

    public EtcdBuilder(Etcd instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public Etcd build() {
        Etcd buildable = new Etcd(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EtcdBuilder that = (EtcdBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

