/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.Authentication;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationFluent;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationSpec;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationSpecBuilder;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationSpecFluentImpl;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationStatus;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusBuilder;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationStatusFluentImpl;
import java.util.Objects;

public class AuthenticationFluentImpl<A extends AuthenticationFluent<A>>
extends BaseFluent<A>
implements AuthenticationFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private AuthenticationSpecBuilder spec;
    private AuthenticationStatusBuilder status;

    public AuthenticationFluentImpl() {
    }

    public AuthenticationFluentImpl(Authentication instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public AuthenticationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public AuthenticationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public AuthenticationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public AuthenticationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public AuthenticationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public AuthenticationSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public AuthenticationSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(AuthenticationSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new AuthenticationSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public AuthenticationFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public AuthenticationFluent.SpecNested<A> withNewSpecLike(AuthenticationSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public AuthenticationFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public AuthenticationFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new AuthenticationSpecBuilder().build());
    }

    @Override
    public AuthenticationFluent.SpecNested<A> editOrNewSpecLike(AuthenticationSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public AuthenticationStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public AuthenticationStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(AuthenticationStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new AuthenticationStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public AuthenticationFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public AuthenticationFluent.StatusNested<A> withNewStatusLike(AuthenticationStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public AuthenticationFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public AuthenticationFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new AuthenticationStatusBuilder().build());
    }

    @Override
    public AuthenticationFluent.StatusNested<A> editOrNewStatusLike(AuthenticationStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationFluentImpl that = (AuthenticationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends AuthenticationStatusFluentImpl<AuthenticationFluent.StatusNested<N>>
    implements AuthenticationFluent.StatusNested<N>,
    Nested<N> {
        private final AuthenticationStatusBuilder builder;

        StatusNestedImpl(AuthenticationStatus item) {
            this.builder = new AuthenticationStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new AuthenticationStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthenticationFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends AuthenticationSpecFluentImpl<AuthenticationFluent.SpecNested<N>>
    implements AuthenticationFluent.SpecNested<N>,
    Nested<N> {
        private final AuthenticationSpecBuilder builder;

        SpecNestedImpl(AuthenticationSpec item) {
            this.builder = new AuthenticationSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new AuthenticationSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthenticationFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<AuthenticationFluent.MetadataNested<N>>
    implements AuthenticationFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)AuthenticationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

