package io.fabric8.openshift.api.model.miscellaneous.network.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class EgressNetworkPolicySpecBuilder extends EgressNetworkPolicySpecFluent<EgressNetworkPolicySpecBuilder> implements VisitableBuilder<EgressNetworkPolicySpec,EgressNetworkPolicySpecBuilder>{
  public EgressNetworkPolicySpecBuilder() {
    this(new EgressNetworkPolicySpec());
  }
  
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent) {
    this(fluent, new EgressNetworkPolicySpec());
  }
  
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent,EgressNetworkPolicySpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  EgressNetworkPolicySpecFluent<?> fluent;
  
  public EgressNetworkPolicySpec build() {
    EgressNetworkPolicySpec buildable = new EgressNetworkPolicySpec(fluent.buildEgress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}