package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class Metal3MachineSpecFluent<A extends Metal3MachineSpecFluent<A>> extends BaseFluent<A>{
  public Metal3MachineSpecFluent() {
  }
  
  public Metal3MachineSpecFluent(Metal3MachineSpec instance) {
    this.copyInstance(instance);
  }
  private String automatedCleaningMode;
  private CustomDeployBuilder customDeploy;
  private ObjectReferenceBuilder dataTemplate;
  private HostSelectorBuilder hostSelector;
  private ImageBuilder image;
  private SecretReference metaData;
  private SecretReference networkData;
  private String providerID;
  private SecretReference userData;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Metal3MachineSpec instance) {
    instance = (instance != null ? instance : new Metal3MachineSpec());
    if (instance != null) {
          this.withAutomatedCleaningMode(instance.getAutomatedCleaningMode());
          this.withCustomDeploy(instance.getCustomDeploy());
          this.withDataTemplate(instance.getDataTemplate());
          this.withHostSelector(instance.getHostSelector());
          this.withImage(instance.getImage());
          this.withMetaData(instance.getMetaData());
          this.withNetworkData(instance.getNetworkData());
          this.withProviderID(instance.getProviderID());
          this.withUserData(instance.getUserData());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAutomatedCleaningMode() {
    return this.automatedCleaningMode;
  }
  
  public A withAutomatedCleaningMode(String automatedCleaningMode) {
    this.automatedCleaningMode = automatedCleaningMode;
    return (A) this;
  }
  
  public boolean hasAutomatedCleaningMode() {
    return this.automatedCleaningMode != null;
  }
  
  public CustomDeploy buildCustomDeploy() {
    return this.customDeploy != null ? this.customDeploy.build() : null;
  }
  
  public A withCustomDeploy(CustomDeploy customDeploy) {
    this._visitables.remove("customDeploy");
    if (customDeploy != null) {
        this.customDeploy = new CustomDeployBuilder(customDeploy);
        this._visitables.get("customDeploy").add(this.customDeploy);
    } else {
        this.customDeploy = null;
        this._visitables.get("customDeploy").remove(this.customDeploy);
    }
    return (A) this;
  }
  
  public boolean hasCustomDeploy() {
    return this.customDeploy != null;
  }
  
  public A withNewCustomDeploy(String method) {
    return (A)withCustomDeploy(new CustomDeploy(method));
  }
  
  public CustomDeployNested<A> withNewCustomDeploy() {
    return new CustomDeployNested(null);
  }
  
  public CustomDeployNested<A> withNewCustomDeployLike(CustomDeploy item) {
    return new CustomDeployNested(item);
  }
  
  public CustomDeployNested<A> editCustomDeploy() {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(null));
  }
  
  public CustomDeployNested<A> editOrNewCustomDeploy() {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(new CustomDeployBuilder().build()));
  }
  
  public CustomDeployNested<A> editOrNewCustomDeployLike(CustomDeploy item) {
    return withNewCustomDeployLike(java.util.Optional.ofNullable(buildCustomDeploy()).orElse(item));
  }
  
  public ObjectReference buildDataTemplate() {
    return this.dataTemplate != null ? this.dataTemplate.build() : null;
  }
  
  public A withDataTemplate(ObjectReference dataTemplate) {
    this._visitables.remove("dataTemplate");
    if (dataTemplate != null) {
        this.dataTemplate = new ObjectReferenceBuilder(dataTemplate);
        this._visitables.get("dataTemplate").add(this.dataTemplate);
    } else {
        this.dataTemplate = null;
        this._visitables.get("dataTemplate").remove(this.dataTemplate);
    }
    return (A) this;
  }
  
  public boolean hasDataTemplate() {
    return this.dataTemplate != null;
  }
  
  public DataTemplateNested<A> withNewDataTemplate() {
    return new DataTemplateNested(null);
  }
  
  public DataTemplateNested<A> withNewDataTemplateLike(ObjectReference item) {
    return new DataTemplateNested(item);
  }
  
  public DataTemplateNested<A> editDataTemplate() {
    return withNewDataTemplateLike(java.util.Optional.ofNullable(buildDataTemplate()).orElse(null));
  }
  
  public DataTemplateNested<A> editOrNewDataTemplate() {
    return withNewDataTemplateLike(java.util.Optional.ofNullable(buildDataTemplate()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public DataTemplateNested<A> editOrNewDataTemplateLike(ObjectReference item) {
    return withNewDataTemplateLike(java.util.Optional.ofNullable(buildDataTemplate()).orElse(item));
  }
  
  public HostSelector buildHostSelector() {
    return this.hostSelector != null ? this.hostSelector.build() : null;
  }
  
  public A withHostSelector(HostSelector hostSelector) {
    this._visitables.remove("hostSelector");
    if (hostSelector != null) {
        this.hostSelector = new HostSelectorBuilder(hostSelector);
        this._visitables.get("hostSelector").add(this.hostSelector);
    } else {
        this.hostSelector = null;
        this._visitables.get("hostSelector").remove(this.hostSelector);
    }
    return (A) this;
  }
  
  public boolean hasHostSelector() {
    return this.hostSelector != null;
  }
  
  public HostSelectorNested<A> withNewHostSelector() {
    return new HostSelectorNested(null);
  }
  
  public HostSelectorNested<A> withNewHostSelectorLike(HostSelector item) {
    return new HostSelectorNested(item);
  }
  
  public HostSelectorNested<A> editHostSelector() {
    return withNewHostSelectorLike(java.util.Optional.ofNullable(buildHostSelector()).orElse(null));
  }
  
  public HostSelectorNested<A> editOrNewHostSelector() {
    return withNewHostSelectorLike(java.util.Optional.ofNullable(buildHostSelector()).orElse(new HostSelectorBuilder().build()));
  }
  
  public HostSelectorNested<A> editOrNewHostSelectorLike(HostSelector item) {
    return withNewHostSelectorLike(java.util.Optional.ofNullable(buildHostSelector()).orElse(item));
  }
  
  public Image buildImage() {
    return this.image != null ? this.image.build() : null;
  }
  
  public A withImage(Image image) {
    this._visitables.remove("image");
    if (image != null) {
        this.image = new ImageBuilder(image);
        this._visitables.get("image").add(this.image);
    } else {
        this.image = null;
        this._visitables.get("image").remove(this.image);
    }
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public A withNewImage(String checksum,String checksumType,String format,String url) {
    return (A)withImage(new Image(checksum, checksumType, format, url));
  }
  
  public ImageNested<A> withNewImage() {
    return new ImageNested(null);
  }
  
  public ImageNested<A> withNewImageLike(Image item) {
    return new ImageNested(item);
  }
  
  public ImageNested<A> editImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(null));
  }
  
  public ImageNested<A> editOrNewImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(new ImageBuilder().build()));
  }
  
  public ImageNested<A> editOrNewImageLike(Image item) {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(item));
  }
  
  public SecretReference getMetaData() {
    return this.metaData;
  }
  
  public A withMetaData(SecretReference metaData) {
    this.metaData = metaData;
    return (A) this;
  }
  
  public boolean hasMetaData() {
    return this.metaData != null;
  }
  
  public A withNewMetaData(String name,String namespace) {
    return (A)withMetaData(new SecretReference(name, namespace));
  }
  
  public SecretReference getNetworkData() {
    return this.networkData;
  }
  
  public A withNetworkData(SecretReference networkData) {
    this.networkData = networkData;
    return (A) this;
  }
  
  public boolean hasNetworkData() {
    return this.networkData != null;
  }
  
  public A withNewNetworkData(String name,String namespace) {
    return (A)withNetworkData(new SecretReference(name, namespace));
  }
  
  public String getProviderID() {
    return this.providerID;
  }
  
  public A withProviderID(String providerID) {
    this.providerID = providerID;
    return (A) this;
  }
  
  public boolean hasProviderID() {
    return this.providerID != null;
  }
  
  public SecretReference getUserData() {
    return this.userData;
  }
  
  public A withUserData(SecretReference userData) {
    this.userData = userData;
    return (A) this;
  }
  
  public boolean hasUserData() {
    return this.userData != null;
  }
  
  public A withNewUserData(String name,String namespace) {
    return (A)withUserData(new SecretReference(name, namespace));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Metal3MachineSpecFluent that = (Metal3MachineSpecFluent) o;
    if (!java.util.Objects.equals(automatedCleaningMode, that.automatedCleaningMode)) return false;
    if (!java.util.Objects.equals(customDeploy, that.customDeploy)) return false;
    if (!java.util.Objects.equals(dataTemplate, that.dataTemplate)) return false;
    if (!java.util.Objects.equals(hostSelector, that.hostSelector)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(metaData, that.metaData)) return false;
    if (!java.util.Objects.equals(networkData, that.networkData)) return false;
    if (!java.util.Objects.equals(providerID, that.providerID)) return false;
    if (!java.util.Objects.equals(userData, that.userData)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(automatedCleaningMode,  customDeploy,  dataTemplate,  hostSelector,  image,  metaData,  networkData,  providerID,  userData,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (automatedCleaningMode != null) { sb.append("automatedCleaningMode:"); sb.append(automatedCleaningMode + ","); }
    if (customDeploy != null) { sb.append("customDeploy:"); sb.append(customDeploy + ","); }
    if (dataTemplate != null) { sb.append("dataTemplate:"); sb.append(dataTemplate + ","); }
    if (hostSelector != null) { sb.append("hostSelector:"); sb.append(hostSelector + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (metaData != null) { sb.append("metaData:"); sb.append(metaData + ","); }
    if (networkData != null) { sb.append("networkData:"); sb.append(networkData + ","); }
    if (providerID != null) { sb.append("providerID:"); sb.append(providerID + ","); }
    if (userData != null) { sb.append("userData:"); sb.append(userData + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CustomDeployNested<N> extends CustomDeployFluent<CustomDeployNested<N>> implements Nested<N>{
    CustomDeployNested(CustomDeploy item) {
      this.builder = new CustomDeployBuilder(this, item);
    }
    CustomDeployBuilder builder;
    
    public N and() {
      return (N) Metal3MachineSpecFluent.this.withCustomDeploy(builder.build());
    }
    
    public N endCustomDeploy() {
      return and();
    }
    
  
  }
  public class DataTemplateNested<N> extends ObjectReferenceFluent<DataTemplateNested<N>> implements Nested<N>{
    DataTemplateNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) Metal3MachineSpecFluent.this.withDataTemplate(builder.build());
    }
    
    public N endDataTemplate() {
      return and();
    }
    
  
  }
  public class HostSelectorNested<N> extends HostSelectorFluent<HostSelectorNested<N>> implements Nested<N>{
    HostSelectorNested(HostSelector item) {
      this.builder = new HostSelectorBuilder(this, item);
    }
    HostSelectorBuilder builder;
    
    public N and() {
      return (N) Metal3MachineSpecFluent.this.withHostSelector(builder.build());
    }
    
    public N endHostSelector() {
      return and();
    }
    
  
  }
  public class ImageNested<N> extends ImageFluent<ImageNested<N>> implements Nested<N>{
    ImageNested(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageBuilder builder;
    
    public N and() {
      return (N) Metal3MachineSpecFluent.this.withImage(builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }

}