package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RAIDConfigBuilder extends RAIDConfigFluent<RAIDConfigBuilder> implements VisitableBuilder<RAIDConfig,RAIDConfigBuilder>{
  public RAIDConfigBuilder() {
    this(new RAIDConfig());
  }
  
  public RAIDConfigBuilder(RAIDConfigFluent<?> fluent) {
    this(fluent, new RAIDConfig());
  }
  
  public RAIDConfigBuilder(RAIDConfigFluent<?> fluent,RAIDConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RAIDConfigBuilder(RAIDConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RAIDConfigFluent<?> fluent;
  
  public RAIDConfig build() {
    RAIDConfig buildable = new RAIDConfig(fluent.buildHardwareRAIDVolumes(),fluent.buildSoftwareRAIDVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}