package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkSelectionElementBuilder extends NetworkSelectionElementFluent<NetworkSelectionElementBuilder> implements VisitableBuilder<NetworkSelectionElement,NetworkSelectionElementBuilder>{
  public NetworkSelectionElementBuilder() {
    this(new NetworkSelectionElement());
  }
  
  public NetworkSelectionElementBuilder(NetworkSelectionElementFluent<?> fluent) {
    this(fluent, new NetworkSelectionElement());
  }
  
  public NetworkSelectionElementBuilder(NetworkSelectionElementFluent<?> fluent,NetworkSelectionElement instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkSelectionElementBuilder(NetworkSelectionElement instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkSelectionElementFluent<?> fluent;
  
  public NetworkSelectionElement build() {
    NetworkSelectionElement buildable = new NetworkSelectionElement(fluent.buildBandwidth(),fluent.getCniArgs(),fluent.getDefaultRoute(),fluent.getInfinibandGuid(),fluent.getInterface(),fluent.getIpamClaimReference(),fluent.getIps(),fluent.getMac(),fluent.getName(),fluent.getNamespace(),fluent.buildPortMappings());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}