package io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DNSBuilder extends DNSFluent<DNSBuilder> implements VisitableBuilder<DNS,DNSBuilder>{
  public DNSBuilder() {
    this(new DNS());
  }
  
  public DNSBuilder(DNSFluent<?> fluent) {
    this(fluent, new DNS());
  }
  
  public DNSBuilder(DNSFluent<?> fluent,DNS instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DNSBuilder(DNS instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DNSFluent<?> fluent;
  
  public DNS build() {
    DNS buildable = new DNS(fluent.getDomain(),fluent.getNameservers(),fluent.getOptions(),fluent.getSearch());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}