package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AzureProviderStatusBuilder extends AzureProviderStatusFluent<AzureProviderStatusBuilder> implements VisitableBuilder<AzureProviderStatus,AzureProviderStatusBuilder>{
  public AzureProviderStatusBuilder() {
    this(new AzureProviderStatus());
  }
  
  public AzureProviderStatusBuilder(AzureProviderStatusFluent<?> fluent) {
    this(fluent, new AzureProviderStatus());
  }
  
  public AzureProviderStatusBuilder(AzureProviderStatusFluent<?> fluent,AzureProviderStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AzureProviderStatusBuilder(AzureProviderStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AzureProviderStatusFluent<?> fluent;
  
  public AzureProviderStatus build() {
    AzureProviderStatus buildable = new AzureProviderStatus(fluent.getApiVersion(),fluent.getAppID(),fluent.getKind(),fluent.getName(),fluent.getSecretLastResourceVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}