package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AccessPolicyFluent<A extends AccessPolicyFluent<A>> extends BaseFluent<A>{
  public AccessPolicyFluent() {
  }
  
  public AccessPolicyFluent(AccessPolicy instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ResourceAttributeBuilder> attributes = new ArrayList<ResourceAttributeBuilder>();
  private List<String> roles = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AccessPolicy instance) {
    instance = (instance != null ? instance : new AccessPolicy());
    if (instance != null) {
          this.withAttributes(instance.getAttributes());
          this.withRoles(instance.getRoles());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAttributes(int index,ResourceAttribute item) {
    if (this.attributes == null) {this.attributes = new ArrayList<ResourceAttributeBuilder>();}
    ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);
    if (index < 0 || index >= attributes.size()) {
        _visitables.get("attributes").add(builder);
        attributes.add(builder);
    } else {
        _visitables.get("attributes").add(builder);
        attributes.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToAttributes(int index,ResourceAttribute item) {
    if (this.attributes == null) {this.attributes = new ArrayList<ResourceAttributeBuilder>();}
    ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);
    if (index < 0 || index >= attributes.size()) {
        _visitables.get("attributes").add(builder);
        attributes.add(builder);
    } else {
        _visitables.get("attributes").add(builder);
        attributes.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToAttributes(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.ResourceAttribute... items) {
    if (this.attributes == null) {this.attributes = new ArrayList<ResourceAttributeBuilder>();}
    for (ResourceAttribute item : items) {ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);_visitables.get("attributes").add(builder);this.attributes.add(builder);} return (A)this;
  }
  
  public A addAllToAttributes(Collection<ResourceAttribute> items) {
    if (this.attributes == null) {this.attributes = new ArrayList<ResourceAttributeBuilder>();}
    for (ResourceAttribute item : items) {ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);_visitables.get("attributes").add(builder);this.attributes.add(builder);} return (A)this;
  }
  
  public A removeFromAttributes(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.ResourceAttribute... items) {
    if (this.attributes == null) return (A)this;
    for (ResourceAttribute item : items) {ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);_visitables.get("attributes").remove(builder); this.attributes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAttributes(Collection<ResourceAttribute> items) {
    if (this.attributes == null) return (A)this;
    for (ResourceAttribute item : items) {ResourceAttributeBuilder builder = new ResourceAttributeBuilder(item);_visitables.get("attributes").remove(builder); this.attributes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAttributes(Predicate<ResourceAttributeBuilder> predicate) {
    if (attributes == null) return (A) this;
    final Iterator<ResourceAttributeBuilder> each = attributes.iterator();
    final List visitables = _visitables.get("attributes");
    while (each.hasNext()) {
      ResourceAttributeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ResourceAttribute> buildAttributes() {
    return this.attributes != null ? build(attributes) : null;
  }
  
  public ResourceAttribute buildAttribute(int index) {
    return this.attributes.get(index).build();
  }
  
  public ResourceAttribute buildFirstAttribute() {
    return this.attributes.get(0).build();
  }
  
  public ResourceAttribute buildLastAttribute() {
    return this.attributes.get(attributes.size() - 1).build();
  }
  
  public ResourceAttribute buildMatchingAttribute(Predicate<ResourceAttributeBuilder> predicate) {
      for (ResourceAttributeBuilder item : attributes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAttribute(Predicate<ResourceAttributeBuilder> predicate) {
      for (ResourceAttributeBuilder item : attributes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAttributes(List<ResourceAttribute> attributes) {
    if (this.attributes != null) {
      this._visitables.get("attributes").clear();
    }
    if (attributes != null) {
        this.attributes = new ArrayList();
        for (ResourceAttribute item : attributes) {
          this.addToAttributes(item);
        }
    } else {
      this.attributes = null;
    }
    return (A) this;
  }
  
  public A withAttributes(io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.ResourceAttribute... attributes) {
    if (this.attributes != null) {
        this.attributes.clear();
        _visitables.remove("attributes");
    }
    if (attributes != null) {
      for (ResourceAttribute item : attributes) {
        this.addToAttributes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAttributes() {
    return this.attributes != null && !this.attributes.isEmpty();
  }
  
  public A addNewAttribute(String name,String operator,String value) {
    return (A)addToAttributes(new ResourceAttribute(name, operator, value));
  }
  
  public AttributesNested<A> addNewAttribute() {
    return new AttributesNested(-1, null);
  }
  
  public AttributesNested<A> addNewAttributeLike(ResourceAttribute item) {
    return new AttributesNested(-1, item);
  }
  
  public AttributesNested<A> setNewAttributeLike(int index,ResourceAttribute item) {
    return new AttributesNested(index, item);
  }
  
  public AttributesNested<A> editAttribute(int index) {
    if (attributes.size() <= index) throw new RuntimeException("Can't edit attributes. Index exceeds size.");
    return setNewAttributeLike(index, buildAttribute(index));
  }
  
  public AttributesNested<A> editFirstAttribute() {
    if (attributes.size() == 0) throw new RuntimeException("Can't edit first attributes. The list is empty.");
    return setNewAttributeLike(0, buildAttribute(0));
  }
  
  public AttributesNested<A> editLastAttribute() {
    int index = attributes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last attributes. The list is empty.");
    return setNewAttributeLike(index, buildAttribute(index));
  }
  
  public AttributesNested<A> editMatchingAttribute(Predicate<ResourceAttributeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<attributes.size();i++) { 
    if (predicate.test(attributes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching attributes. No match found.");
    return setNewAttributeLike(index, buildAttribute(index));
  }
  
  public A addToRoles(int index,String item) {
    if (this.roles == null) {this.roles = new ArrayList<String>();}
    this.roles.add(index, item);
    return (A)this;
  }
  
  public A setToRoles(int index,String item) {
    if (this.roles == null) {this.roles = new ArrayList<String>();}
    this.roles.set(index, item); return (A)this;
  }
  
  public A addToRoles(java.lang.String... items) {
    if (this.roles == null) {this.roles = new ArrayList<String>();}
    for (String item : items) {this.roles.add(item);} return (A)this;
  }
  
  public A addAllToRoles(Collection<String> items) {
    if (this.roles == null) {this.roles = new ArrayList<String>();}
    for (String item : items) {this.roles.add(item);} return (A)this;
  }
  
  public A removeFromRoles(java.lang.String... items) {
    if (this.roles == null) return (A)this;
    for (String item : items) { this.roles.remove(item);} return (A)this;
  }
  
  public A removeAllFromRoles(Collection<String> items) {
    if (this.roles == null) return (A)this;
    for (String item : items) { this.roles.remove(item);} return (A)this;
  }
  
  public List<String> getRoles() {
    return this.roles;
  }
  
  public String getRole(int index) {
    return this.roles.get(index);
  }
  
  public String getFirstRole() {
    return this.roles.get(0);
  }
  
  public String getLastRole() {
    return this.roles.get(roles.size() - 1);
  }
  
  public String getMatchingRole(Predicate<String> predicate) {
      for (String item : roles) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingRole(Predicate<String> predicate) {
      for (String item : roles) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRoles(List<String> roles) {
    if (roles != null) {
        this.roles = new ArrayList();
        for (String item : roles) {
          this.addToRoles(item);
        }
    } else {
      this.roles = null;
    }
    return (A) this;
  }
  
  public A withRoles(java.lang.String... roles) {
    if (this.roles != null) {
        this.roles.clear();
        _visitables.remove("roles");
    }
    if (roles != null) {
      for (String item : roles) {
        this.addToRoles(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRoles() {
    return this.roles != null && !this.roles.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AccessPolicyFluent that = (AccessPolicyFluent) o;
    if (!java.util.Objects.equals(attributes, that.attributes)) return false;
    if (!java.util.Objects.equals(roles, that.roles)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(attributes,  roles,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attributes != null && !attributes.isEmpty()) { sb.append("attributes:"); sb.append(attributes + ","); }
    if (roles != null && !roles.isEmpty()) { sb.append("roles:"); sb.append(roles + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AttributesNested<N> extends ResourceAttributeFluent<AttributesNested<N>> implements Nested<N>{
    AttributesNested(int index,ResourceAttribute item) {
      this.index = index;
      this.builder = new ResourceAttributeBuilder(this, item);
    }
    ResourceAttributeBuilder builder;
    int index;
    
    public N and() {
      return (N) AccessPolicyFluent.this.setToAttributes(index,builder.build());
    }
    
    public N endAttribute() {
      return and();
    }
    
  
  }

}