package io.fabric8.openshift.api.model.miscellaneous.network.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RedirectConfigBuilder extends RedirectConfigFluent<RedirectConfigBuilder> implements VisitableBuilder<RedirectConfig,RedirectConfigBuilder>{
  public RedirectConfigBuilder() {
    this(new RedirectConfig());
  }
  
  public RedirectConfigBuilder(RedirectConfigFluent<?> fluent) {
    this(fluent, new RedirectConfig());
  }
  
  public RedirectConfigBuilder(RedirectConfigFluent<?> fluent,RedirectConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RedirectConfigBuilder(RedirectConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RedirectConfigFluent<?> fluent;
  
  public RedirectConfig build() {
    RedirectConfig buildable = new RedirectConfig(fluent.getFallbackIP(),fluent.buildRedirectRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}