package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class APIRequestCountBuilder extends APIRequestCountFluent<APIRequestCountBuilder> implements VisitableBuilder<APIRequestCount,APIRequestCountBuilder>{
  public APIRequestCountBuilder() {
    this(new APIRequestCount());
  }
  
  public APIRequestCountBuilder(APIRequestCountFluent<?> fluent) {
    this(fluent, new APIRequestCount());
  }
  
  public APIRequestCountBuilder(APIRequestCountFluent<?> fluent,APIRequestCount instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public APIRequestCountBuilder(APIRequestCount instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  APIRequestCountFluent<?> fluent;
  
  public APIRequestCount build() {
    APIRequestCount buildable = new APIRequestCount(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}