/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestSpec;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CredentialsRequestSpecFluentImpl<A extends CredentialsRequestSpecFluent<A>>
extends BaseFluent<A>
implements CredentialsRequestSpecFluent<A> {
    private Map<String, Object> providerSpec;
    private ObjectReferenceBuilder secretRef;
    private List<String> serviceAccountNames = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CredentialsRequestSpecFluentImpl() {
    }

    public CredentialsRequestSpecFluentImpl(CredentialsRequestSpec instance) {
        this.withProviderSpec(instance.getProviderSpec());
        this.withSecretRef(instance.getSecretRef());
        this.withServiceAccountNames(instance.getServiceAccountNames());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToProviderSpec(String key, Object value) {
        if (this.providerSpec == null && key != null && value != null) {
            this.providerSpec = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.providerSpec.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToProviderSpec(Map<String, Object> map) {
        if (this.providerSpec == null && map != null) {
            this.providerSpec = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.providerSpec.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromProviderSpec(String key) {
        if (this.providerSpec == null) {
            return (A)this;
        }
        if (key != null && this.providerSpec != null) {
            this.providerSpec.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromProviderSpec(Map<String, Object> map) {
        if (this.providerSpec == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.providerSpec == null) continue;
                this.providerSpec.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getProviderSpec() {
        return this.providerSpec;
    }

    @Override
    public <K, V> A withProviderSpec(Map<String, Object> providerSpec) {
        this.providerSpec = providerSpec == null ? null : new LinkedHashMap<String, Object>(providerSpec);
        return (A)this;
    }

    @Override
    public Boolean hasProviderSpec() {
        return this.providerSpec != null;
    }

    @Override
    @Deprecated
    public ObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public ObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(ObjectReference secretRef) {
        this._visitables.get((Object)"secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new ObjectReferenceBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public CredentialsRequestSpecFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public CredentialsRequestSpecFluent.SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public CredentialsRequestSpecFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public CredentialsRequestSpecFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public CredentialsRequestSpecFluent.SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public A addToServiceAccountNames(Integer index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServiceAccountNames(Integer index, String item) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        this.serviceAccountNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServiceAccountNames(String ... items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {
            this.serviceAccountNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccountNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceAccountNames(String ... items) {
        for (String item : items) {
            if (this.serviceAccountNames == null) continue;
            this.serviceAccountNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceAccountNames(Collection<String> items) {
        for (String item : items) {
            if (this.serviceAccountNames == null) continue;
            this.serviceAccountNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServiceAccountNames() {
        return this.serviceAccountNames;
    }

    @Override
    public String getServiceAccountName(Integer index) {
        return this.serviceAccountNames.get(index);
    }

    @Override
    public String getFirstServiceAccountName() {
        return this.serviceAccountNames.get(0);
    }

    @Override
    public String getLastServiceAccountName() {
        return this.serviceAccountNames.get(this.serviceAccountNames.size() - 1);
    }

    @Override
    public String getMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceAccountName(Predicate<String> predicate) {
        for (String item : this.serviceAccountNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceAccountNames(List<String> serviceAccountNames) {
        if (serviceAccountNames != null) {
            this.serviceAccountNames = new ArrayList<String>();
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        } else {
            this.serviceAccountNames = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceAccountNames(String ... serviceAccountNames) {
        if (this.serviceAccountNames != null) {
            this.serviceAccountNames.clear();
        }
        if (serviceAccountNames != null) {
            for (String item : serviceAccountNames) {
                this.addToServiceAccountNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountNames() {
        return this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialsRequestSpecFluentImpl that = (CredentialsRequestSpecFluentImpl)o;
        if (this.providerSpec != null ? !this.providerSpec.equals(that.providerSpec) : that.providerSpec != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals((Object)that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.serviceAccountNames != null ? !this.serviceAccountNames.equals(that.serviceAccountNames) : that.serviceAccountNames != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.providerSpec, this.secretRef, this.serviceAccountNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.providerSpec != null && !this.providerSpec.isEmpty()) {
            sb.append("providerSpec:");
            sb.append(this.providerSpec + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty()) {
            sb.append("serviceAccountNames:");
            sb.append(this.serviceAccountNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SecretRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<CredentialsRequestSpecFluent.SecretRefNested<N>>
    implements CredentialsRequestSpecFluent.SecretRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        SecretRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)CredentialsRequestSpecFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

