/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ContainerRuntimeConfigSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ContainerRuntimeConfiguration;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ContainerRuntimeConfigurationBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ContainerRuntimeConfigurationFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContainerRuntimeConfigSpecFluent<A extends ContainerRuntimeConfigSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ContainerRuntimeConfigurationBuilder containerRuntimeConfig;
    private LabelSelectorBuilder machineConfigPoolSelector;

    public ContainerRuntimeConfigSpecFluent() {
    }

    public ContainerRuntimeConfigSpecFluent(ContainerRuntimeConfigSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ContainerRuntimeConfiguration buildContainerRuntimeConfig() {
        return this.containerRuntimeConfig != null ? this.containerRuntimeConfig.build() : null;
    }

    public LabelSelector buildMachineConfigPoolSelector() {
        return this.machineConfigPoolSelector != null ? this.machineConfigPoolSelector.build() : null;
    }

    protected void copyInstance(ContainerRuntimeConfigSpec instance) {
        ContainerRuntimeConfigSpec containerRuntimeConfigSpec = instance = instance != null ? instance : new ContainerRuntimeConfigSpec();
        if (instance != null) {
            this.withContainerRuntimeConfig(instance.getContainerRuntimeConfig());
            this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ContainerRuntimeConfigNested<A> editContainerRuntimeConfig() {
        return this.withNewContainerRuntimeConfigLike(Optional.ofNullable(this.buildContainerRuntimeConfig()).orElse(null));
    }

    public MachineConfigPoolSelectorNested<A> editMachineConfigPoolSelector() {
        return this.withNewMachineConfigPoolSelectorLike(Optional.ofNullable(this.buildMachineConfigPoolSelector()).orElse(null));
    }

    public ContainerRuntimeConfigNested<A> editOrNewContainerRuntimeConfig() {
        return this.withNewContainerRuntimeConfigLike(Optional.ofNullable(this.buildContainerRuntimeConfig()).orElse(new ContainerRuntimeConfigurationBuilder().build()));
    }

    public ContainerRuntimeConfigNested<A> editOrNewContainerRuntimeConfigLike(ContainerRuntimeConfiguration item) {
        return this.withNewContainerRuntimeConfigLike(Optional.ofNullable(this.buildContainerRuntimeConfig()).orElse(item));
    }

    public MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelector() {
        return this.withNewMachineConfigPoolSelectorLike(Optional.ofNullable(this.buildMachineConfigPoolSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public MachineConfigPoolSelectorNested<A> editOrNewMachineConfigPoolSelectorLike(LabelSelector item) {
        return this.withNewMachineConfigPoolSelectorLike(Optional.ofNullable(this.buildMachineConfigPoolSelector()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerRuntimeConfigSpecFluent that = (ContainerRuntimeConfigSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.containerRuntimeConfig, (Object)that.containerRuntimeConfig)) {
            return false;
        }
        if (!Objects.equals(this.machineConfigPoolSelector, that.machineConfigPoolSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasContainerRuntimeConfig() {
        return this.containerRuntimeConfig != null;
    }

    public boolean hasMachineConfigPoolSelector() {
        return this.machineConfigPoolSelector != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerRuntimeConfig, this.machineConfigPoolSelector, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerRuntimeConfig != null) {
            sb.append("containerRuntimeConfig:");
            sb.append((Object)this.containerRuntimeConfig);
            sb.append(",");
        }
        if (this.machineConfigPoolSelector != null) {
            sb.append("machineConfigPoolSelector:");
            sb.append(this.machineConfigPoolSelector);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withContainerRuntimeConfig(ContainerRuntimeConfiguration containerRuntimeConfig) {
        this._visitables.remove((Object)"containerRuntimeConfig");
        if (containerRuntimeConfig != null) {
            this.containerRuntimeConfig = new ContainerRuntimeConfigurationBuilder(containerRuntimeConfig);
            this._visitables.get((Object)"containerRuntimeConfig").add(this.containerRuntimeConfig);
        } else {
            this.containerRuntimeConfig = null;
            this._visitables.get((Object)"containerRuntimeConfig").remove((Object)this.containerRuntimeConfig);
        }
        return (A)((Object)this);
    }

    public A withMachineConfigPoolSelector(LabelSelector machineConfigPoolSelector) {
        this._visitables.remove((Object)"machineConfigPoolSelector");
        if (machineConfigPoolSelector != null) {
            this.machineConfigPoolSelector = new LabelSelectorBuilder(machineConfigPoolSelector);
            this._visitables.get((Object)"machineConfigPoolSelector").add(this.machineConfigPoolSelector);
        } else {
            this.machineConfigPoolSelector = null;
            this._visitables.get((Object)"machineConfigPoolSelector").remove(this.machineConfigPoolSelector);
        }
        return (A)((Object)this);
    }

    public ContainerRuntimeConfigNested<A> withNewContainerRuntimeConfig() {
        return new ContainerRuntimeConfigNested(null);
    }

    public ContainerRuntimeConfigNested<A> withNewContainerRuntimeConfigLike(ContainerRuntimeConfiguration item) {
        return new ContainerRuntimeConfigNested(item);
    }

    public MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelector() {
        return new MachineConfigPoolSelectorNested(null);
    }

    public MachineConfigPoolSelectorNested<A> withNewMachineConfigPoolSelectorLike(LabelSelector item) {
        return new MachineConfigPoolSelectorNested(item);
    }

    public class MachineConfigPoolSelectorNested<N>
    extends LabelSelectorFluent<MachineConfigPoolSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        MachineConfigPoolSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ContainerRuntimeConfigSpecFluent.this.withMachineConfigPoolSelector(this.builder.build());
        }

        public N endMachineConfigPoolSelector() {
            return this.and();
        }
    }

    public class ContainerRuntimeConfigNested<N>
    extends ContainerRuntimeConfigurationFluent<ContainerRuntimeConfigNested<N>>
    implements Nested<N> {
        ContainerRuntimeConfigurationBuilder builder;

        ContainerRuntimeConfigNested(ContainerRuntimeConfiguration item) {
            this.builder = new ContainerRuntimeConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)ContainerRuntimeConfigSpecFluent.this.withContainerRuntimeConfig(this.builder.build());
        }

        public N endContainerRuntimeConfig() {
            return this.and();
        }
    }
}

