package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineOSConfigSpecBuilder extends MachineOSConfigSpecFluent<MachineOSConfigSpecBuilder> implements VisitableBuilder<MachineOSConfigSpec,MachineOSConfigSpecBuilder>{
  public MachineOSConfigSpecBuilder() {
    this(new MachineOSConfigSpec());
  }
  
  public MachineOSConfigSpecBuilder(MachineOSConfigSpecFluent<?> fluent) {
    this(fluent, new MachineOSConfigSpec());
  }
  
  public MachineOSConfigSpecBuilder(MachineOSConfigSpecFluent<?> fluent,MachineOSConfigSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineOSConfigSpecBuilder(MachineOSConfigSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineOSConfigSpecFluent<?> fluent;
  
  public MachineOSConfigSpec build() {
    MachineOSConfigSpec buildable = new MachineOSConfigSpec(fluent.buildBuildInputs(),fluent.buildBuildOutputs(),fluent.buildMachineConfigPool());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}