package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineOSBuildSpecFluent<A extends MachineOSBuildSpecFluent<A>> extends BaseFluent<A>{
  public MachineOSBuildSpecFluent() {
  }
  
  public MachineOSBuildSpecFluent(MachineOSBuildSpec instance) {
    this.copyInstance(instance);
  }
  private Long configGeneration;
  private RenderedMachineConfigReferenceBuilder desiredConfig;
  private MachineOSConfigReferenceBuilder machineOSConfig;
  private String renderedImagePushspec;
  private Long version;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineOSBuildSpec instance) {
    instance = (instance != null ? instance : new MachineOSBuildSpec());
    if (instance != null) {
          this.withConfigGeneration(instance.getConfigGeneration());
          this.withDesiredConfig(instance.getDesiredConfig());
          this.withMachineOSConfig(instance.getMachineOSConfig());
          this.withRenderedImagePushspec(instance.getRenderedImagePushspec());
          this.withVersion(instance.getVersion());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Long getConfigGeneration() {
    return this.configGeneration;
  }
  
  public A withConfigGeneration(Long configGeneration) {
    this.configGeneration = configGeneration;
    return (A) this;
  }
  
  public boolean hasConfigGeneration() {
    return this.configGeneration != null;
  }
  
  public RenderedMachineConfigReference buildDesiredConfig() {
    return this.desiredConfig != null ? this.desiredConfig.build() : null;
  }
  
  public A withDesiredConfig(RenderedMachineConfigReference desiredConfig) {
    this._visitables.remove("desiredConfig");
    if (desiredConfig != null) {
        this.desiredConfig = new RenderedMachineConfigReferenceBuilder(desiredConfig);
        this._visitables.get("desiredConfig").add(this.desiredConfig);
    } else {
        this.desiredConfig = null;
        this._visitables.get("desiredConfig").remove(this.desiredConfig);
    }
    return (A) this;
  }
  
  public boolean hasDesiredConfig() {
    return this.desiredConfig != null;
  }
  
  public A withNewDesiredConfig(String name) {
    return (A)withDesiredConfig(new RenderedMachineConfigReference(name));
  }
  
  public DesiredConfigNested<A> withNewDesiredConfig() {
    return new DesiredConfigNested(null);
  }
  
  public DesiredConfigNested<A> withNewDesiredConfigLike(RenderedMachineConfigReference item) {
    return new DesiredConfigNested(item);
  }
  
  public DesiredConfigNested<A> editDesiredConfig() {
    return withNewDesiredConfigLike(java.util.Optional.ofNullable(buildDesiredConfig()).orElse(null));
  }
  
  public DesiredConfigNested<A> editOrNewDesiredConfig() {
    return withNewDesiredConfigLike(java.util.Optional.ofNullable(buildDesiredConfig()).orElse(new RenderedMachineConfigReferenceBuilder().build()));
  }
  
  public DesiredConfigNested<A> editOrNewDesiredConfigLike(RenderedMachineConfigReference item) {
    return withNewDesiredConfigLike(java.util.Optional.ofNullable(buildDesiredConfig()).orElse(item));
  }
  
  public MachineOSConfigReference buildMachineOSConfig() {
    return this.machineOSConfig != null ? this.machineOSConfig.build() : null;
  }
  
  public A withMachineOSConfig(MachineOSConfigReference machineOSConfig) {
    this._visitables.remove("machineOSConfig");
    if (machineOSConfig != null) {
        this.machineOSConfig = new MachineOSConfigReferenceBuilder(machineOSConfig);
        this._visitables.get("machineOSConfig").add(this.machineOSConfig);
    } else {
        this.machineOSConfig = null;
        this._visitables.get("machineOSConfig").remove(this.machineOSConfig);
    }
    return (A) this;
  }
  
  public boolean hasMachineOSConfig() {
    return this.machineOSConfig != null;
  }
  
  public A withNewMachineOSConfig(String name) {
    return (A)withMachineOSConfig(new MachineOSConfigReference(name));
  }
  
  public MachineOSConfigNested<A> withNewMachineOSConfig() {
    return new MachineOSConfigNested(null);
  }
  
  public MachineOSConfigNested<A> withNewMachineOSConfigLike(MachineOSConfigReference item) {
    return new MachineOSConfigNested(item);
  }
  
  public MachineOSConfigNested<A> editMachineOSConfig() {
    return withNewMachineOSConfigLike(java.util.Optional.ofNullable(buildMachineOSConfig()).orElse(null));
  }
  
  public MachineOSConfigNested<A> editOrNewMachineOSConfig() {
    return withNewMachineOSConfigLike(java.util.Optional.ofNullable(buildMachineOSConfig()).orElse(new MachineOSConfigReferenceBuilder().build()));
  }
  
  public MachineOSConfigNested<A> editOrNewMachineOSConfigLike(MachineOSConfigReference item) {
    return withNewMachineOSConfigLike(java.util.Optional.ofNullable(buildMachineOSConfig()).orElse(item));
  }
  
  public String getRenderedImagePushspec() {
    return this.renderedImagePushspec;
  }
  
  public A withRenderedImagePushspec(String renderedImagePushspec) {
    this.renderedImagePushspec = renderedImagePushspec;
    return (A) this;
  }
  
  public boolean hasRenderedImagePushspec() {
    return this.renderedImagePushspec != null;
  }
  
  public Long getVersion() {
    return this.version;
  }
  
  public A withVersion(Long version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineOSBuildSpecFluent that = (MachineOSBuildSpecFluent) o;
    if (!java.util.Objects.equals(configGeneration, that.configGeneration)) return false;
    if (!java.util.Objects.equals(desiredConfig, that.desiredConfig)) return false;
    if (!java.util.Objects.equals(machineOSConfig, that.machineOSConfig)) return false;
    if (!java.util.Objects.equals(renderedImagePushspec, that.renderedImagePushspec)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(configGeneration,  desiredConfig,  machineOSConfig,  renderedImagePushspec,  version,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configGeneration != null) { sb.append("configGeneration:"); sb.append(configGeneration + ","); }
    if (desiredConfig != null) { sb.append("desiredConfig:"); sb.append(desiredConfig + ","); }
    if (machineOSConfig != null) { sb.append("machineOSConfig:"); sb.append(machineOSConfig + ","); }
    if (renderedImagePushspec != null) { sb.append("renderedImagePushspec:"); sb.append(renderedImagePushspec + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DesiredConfigNested<N> extends RenderedMachineConfigReferenceFluent<DesiredConfigNested<N>> implements Nested<N>{
    DesiredConfigNested(RenderedMachineConfigReference item) {
      this.builder = new RenderedMachineConfigReferenceBuilder(this, item);
    }
    RenderedMachineConfigReferenceBuilder builder;
    
    public N and() {
      return (N) MachineOSBuildSpecFluent.this.withDesiredConfig(builder.build());
    }
    
    public N endDesiredConfig() {
      return and();
    }
    
  
  }
  public class MachineOSConfigNested<N> extends MachineOSConfigReferenceFluent<MachineOSConfigNested<N>> implements Nested<N>{
    MachineOSConfigNested(MachineOSConfigReference item) {
      this.builder = new MachineOSConfigReferenceBuilder(this, item);
    }
    MachineOSConfigReferenceBuilder builder;
    
    public N and() {
      return (N) MachineOSBuildSpecFluent.this.withMachineOSConfig(builder.build());
    }
    
    public N endMachineOSConfig() {
      return and();
    }
    
  
  }

}