package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BuildInputsBuilder extends BuildInputsFluent<BuildInputsBuilder> implements VisitableBuilder<BuildInputs,BuildInputsBuilder>{
  public BuildInputsBuilder() {
    this(new BuildInputs());
  }
  
  public BuildInputsBuilder(BuildInputsFluent<?> fluent) {
    this(fluent, new BuildInputs());
  }
  
  public BuildInputsBuilder(BuildInputsFluent<?> fluent,BuildInputs instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BuildInputsBuilder(BuildInputs instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BuildInputsFluent<?> fluent;
  
  public BuildInputs build() {
    BuildInputs buildable = new BuildInputs(fluent.buildBaseImagePullSecret(),fluent.getBaseOSExtensionsImagePullspec(),fluent.getBaseOSImagePullspec(),fluent.buildContainerFile(),fluent.buildImageBuilder(),fluent.getReleaseVersion(),fluent.buildRenderedImagePushSecret(),fluent.getRenderedImagePushspec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}