package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineOSBuildStatusBuilder extends MachineOSBuildStatusFluent<MachineOSBuildStatusBuilder> implements VisitableBuilder<MachineOSBuildStatus,MachineOSBuildStatusBuilder>{
  public MachineOSBuildStatusBuilder() {
    this(new MachineOSBuildStatus());
  }
  
  public MachineOSBuildStatusBuilder(MachineOSBuildStatusFluent<?> fluent) {
    this(fluent, new MachineOSBuildStatus());
  }
  
  public MachineOSBuildStatusBuilder(MachineOSBuildStatusFluent<?> fluent,MachineOSBuildStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineOSBuildStatusBuilder(MachineOSBuildStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineOSBuildStatusFluent<?> fluent;
  
  public MachineOSBuildStatus build() {
    MachineOSBuildStatus buildable = new MachineOSBuildStatus(fluent.getBuildEnd(),fluent.getBuildStart(),fluent.buildBuilder(),fluent.getConditions(),fluent.getDigestedImagePushSpec(),fluent.buildRelatedObjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}