package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KubeletConfigStatusBuilder extends KubeletConfigStatusFluent<KubeletConfigStatusBuilder> implements VisitableBuilder<KubeletConfigStatus,KubeletConfigStatusBuilder>{
  public KubeletConfigStatusBuilder() {
    this(new KubeletConfigStatus());
  }
  
  public KubeletConfigStatusBuilder(KubeletConfigStatusFluent<?> fluent) {
    this(fluent, new KubeletConfigStatus());
  }
  
  public KubeletConfigStatusBuilder(KubeletConfigStatusFluent<?> fluent,KubeletConfigStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KubeletConfigStatusBuilder(KubeletConfigStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KubeletConfigStatusFluent<?> fluent;
  
  public KubeletConfigStatus build() {
    KubeletConfigStatus buildable = new KubeletConfigStatus(fluent.buildConditions(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}