package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeletConfigBuilder extends KubeletConfigFluentImpl<KubeletConfigBuilder> implements VisitableBuilder<KubeletConfig,KubeletConfigBuilder>{
  public KubeletConfigBuilder() {
    this(false);
  }
  public KubeletConfigBuilder(Boolean validationEnabled) {
    this(new KubeletConfig(), validationEnabled);
  }
  public KubeletConfigBuilder(KubeletConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeletConfigBuilder(KubeletConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeletConfig(), validationEnabled);
  }
  public KubeletConfigBuilder(KubeletConfigFluent<?> fluent,KubeletConfig instance) {
    this(fluent, instance, false);
  }
  public KubeletConfigBuilder(KubeletConfigFluent<?> fluent,KubeletConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubeletConfigBuilder(KubeletConfig instance) {
    this(instance,false);
  }
  public KubeletConfigBuilder(KubeletConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KubeletConfigFluent<?> fluent;
  Boolean validationEnabled;
  public KubeletConfig build() {
    KubeletConfig buildable = new KubeletConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}