package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControllerConfigSpecBuilder extends ControllerConfigSpecFluentImpl<ControllerConfigSpecBuilder> implements VisitableBuilder<ControllerConfigSpec,ControllerConfigSpecBuilder>{
  public ControllerConfigSpecBuilder() {
    this(false);
  }
  public ControllerConfigSpecBuilder(Boolean validationEnabled) {
    this(new ControllerConfigSpec(), validationEnabled);
  }
  public ControllerConfigSpecBuilder(ControllerConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ControllerConfigSpecBuilder(ControllerConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControllerConfigSpec(), validationEnabled);
  }
  public ControllerConfigSpecBuilder(ControllerConfigSpecFluent<?> fluent,ControllerConfigSpec instance) {
    this(fluent, instance, false);
  }
  public ControllerConfigSpecBuilder(ControllerConfigSpecFluent<?> fluent,ControllerConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalTrustBundle(instance.getAdditionalTrustBundle()); 
    fluent.withCloudProviderCAData(instance.getCloudProviderCAData()); 
    fluent.withCloudProviderConfig(instance.getCloudProviderConfig()); 
    fluent.withClusterDNSIP(instance.getClusterDNSIP()); 
    fluent.withDns(instance.getDns()); 
    fluent.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
    fluent.withImages(instance.getImages()); 
    fluent.withInfra(instance.getInfra()); 
    fluent.withIpFamilies(instance.getIpFamilies()); 
    fluent.withKubeAPIServerServingCAData(instance.getKubeAPIServerServingCAData()); 
    fluent.withNetworkType(instance.getNetworkType()); 
    fluent.withOsImageURL(instance.getOsImageURL()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withProxy(instance.getProxy()); 
    fluent.withPullSecret(instance.getPullSecret()); 
    fluent.withReleaseImage(instance.getReleaseImage()); 
    fluent.withRootCAData(instance.getRootCAData()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ControllerConfigSpecBuilder(ControllerConfigSpec instance) {
    this(instance,false);
  }
  public ControllerConfigSpecBuilder(ControllerConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle()); 
    this.withCloudProviderCAData(instance.getCloudProviderCAData()); 
    this.withCloudProviderConfig(instance.getCloudProviderConfig()); 
    this.withClusterDNSIP(instance.getClusterDNSIP()); 
    this.withDns(instance.getDns()); 
    this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain()); 
    this.withImages(instance.getImages()); 
    this.withInfra(instance.getInfra()); 
    this.withIpFamilies(instance.getIpFamilies()); 
    this.withKubeAPIServerServingCAData(instance.getKubeAPIServerServingCAData()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withOsImageURL(instance.getOsImageURL()); 
    this.withPlatform(instance.getPlatform()); 
    this.withProxy(instance.getProxy()); 
    this.withPullSecret(instance.getPullSecret()); 
    this.withReleaseImage(instance.getReleaseImage()); 
    this.withRootCAData(instance.getRootCAData()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ControllerConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ControllerConfigSpec build() {
    ControllerConfigSpec buildable = new ControllerConfigSpec(fluent.getAdditionalTrustBundle(),fluent.getCloudProviderCAData(),fluent.getCloudProviderConfig(),fluent.getClusterDNSIP(),fluent.getDns(),fluent.getEtcdDiscoveryDomain(),fluent.getImages(),fluent.getInfra(),fluent.getIpFamilies(),fluent.getKubeAPIServerServingCAData(),fluent.getNetworkType(),fluent.getOsImageURL(),fluent.getPlatform(),fluent.getProxy(),fluent.getPullSecret(),fluent.getReleaseImage(),fluent.getRootCAData());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}