package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerRuntimeConfigurationBuilder extends ContainerRuntimeConfigurationFluentImpl<ContainerRuntimeConfigurationBuilder> implements VisitableBuilder<ContainerRuntimeConfiguration,ContainerRuntimeConfigurationBuilder>{
  public ContainerRuntimeConfigurationBuilder() {
    this(false);
  }
  public ContainerRuntimeConfigurationBuilder(Boolean validationEnabled) {
    this(new ContainerRuntimeConfiguration(), validationEnabled);
  }
  public ContainerRuntimeConfigurationBuilder(ContainerRuntimeConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerRuntimeConfigurationBuilder(ContainerRuntimeConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerRuntimeConfiguration(), validationEnabled);
  }
  public ContainerRuntimeConfigurationBuilder(ContainerRuntimeConfigurationFluent<?> fluent,ContainerRuntimeConfiguration instance) {
    this(fluent, instance, false);
  }
  public ContainerRuntimeConfigurationBuilder(ContainerRuntimeConfigurationFluent<?> fluent,ContainerRuntimeConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withLogSizeMax(instance.getLogSizeMax()); 
    fluent.withOverlaySize(instance.getOverlaySize()); 
    fluent.withPidsLimit(instance.getPidsLimit()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerRuntimeConfigurationBuilder(ContainerRuntimeConfiguration instance) {
    this(instance,false);
  }
  public ContainerRuntimeConfigurationBuilder(ContainerRuntimeConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLogLevel(instance.getLogLevel()); 
    this.withLogSizeMax(instance.getLogSizeMax()); 
    this.withOverlaySize(instance.getOverlaySize()); 
    this.withPidsLimit(instance.getPidsLimit()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ContainerRuntimeConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerRuntimeConfiguration build() {
    ContainerRuntimeConfiguration buildable = new ContainerRuntimeConfiguration(fluent.getLogLevel(),fluent.getLogSizeMax(),fluent.getOverlaySize(),fluent.getPidsLimit());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}